/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.view.JSChannel;
import org.jsampler.view.JSChannelsPane;
import org.jsampler.view.JSMainFrame;
import org.jsampler.view.classic.ChangeTabTitleDlg;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.ClassicPrefs;
import org.jsampler.view.classic.CloseTabDlg;
import org.jsampler.view.classic.HelpAboutDlg;
import org.jsampler.view.classic.InstrumentsDbFrame;
import org.jsampler.view.classic.LeftPane;
import org.jsampler.view.classic.MainFrame;
import org.jsampler.view.classic.NewChannelsTabDlg;
import org.jsampler.view.classic.PrefsDlg;
import org.jsampler.view.classic.RemoveMidiInstrumentMapDlg;
import org.jsampler.view.classic.Res;
import org.jsampler.view.classic.SamplerInfoDlg;
import org.jsampler.view.std.JSAddMidiInstrumentMapDlg;
import org.jsampler.view.std.JSNewAudioDeviceDlg;
import org.jsampler.view.std.JSNewMidiDeviceDlg;
import org.jsampler.view.std.JSNewMidiInstrumentWizard;
import org.jsampler.view.std.StdA4n;

public class A4n
extends StdA4n {
    protected static A4n a4n = new A4n();
    public static final Action samplerInfo = new SamplerInfo();
    public static final Action addMidiInstrumentMap = new AddMidiInstrumentMap();
    public static final Action removeMidiInstrumentMap = new RemoveMidiInstrumentMap();
    public static final Action addMidiInstrumentWizard = new AddMidiInstrumentWizard();
    public static final Action loadScript = new LoadLscpScript();
    public static final Action addMidiDevice = new AddMidiDevice();
    public static final Action addAudioDevice = new AddAudioDevice();
    public static final Action preferences = new Preferences();
    public static final Action newChannel = new NewChannel();
    public static final Action newChannelWizard = new NewChannelWizard();
    public static final Action newChannelsTab = new NewChannelsTab();
    public static final Action editTabTitle = new EditTabTitle();
    public static final Action moveTab2Beginning = new MoveTab2Beginning();
    public static final Action moveTab2Left = new MoveTab2Left();
    public static final Action moveTab2Right = new MoveTab2Right();
    public static final Action moveTab2End = new MoveTab2End();
    public static final Action closeChannelsTab = new CloseChannelsTab();
    public static final WindowInstrumentsDb windowInstrumentsDb = new WindowInstrumentsDb();
    public static final HelpAbout helpAbout = new HelpAbout();

    private A4n() {
        this.refresh.putValue("SmallIcon", Res.iconReload32);
        this.resetSampler.putValue("SmallIcon", Res.iconReset32);
        this.exportSamplerConfig.putValue("SmallIcon", Res.iconExportSession32);
        this.exportMidiInstrumentMaps.putValue("SmallIcon", Res.iconExport16);
        this.moveChannelsUp.putValue("SmallIcon", Res.iconUp24);
        this.moveChannelsDown.putValue("SmallIcon", Res.iconDown24);
        this.duplicateChannels.putValue("SmallIcon", Res.iconCopy24);
        this.removeChannels.putValue("SmallIcon", Res.iconDelete24);
    }

    @Override
    protected ClassicPrefs preferences() {
        return ClassicPrefs.preferences();
    }

    private static boolean verifyConnection() {
        if (!CC.getClient().isConnected()) {
            HF.showErrorMessage(ClassicI18n.i18n.getError("notConnected"));
            return false;
        }
        return true;
    }

    private static class HelpAbout
    extends AbstractAction {
        HelpAbout() {
            super(ClassicI18n.i18n.getMenuLabel("help.about", "JS Classic"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new HelpAboutDlg(CC.getMainFrame()).setVisible(true);
        }
    }

    private static class WindowInstrumentsDb
    extends AbstractAction {
        InstrumentsDbFrame instrumentsDbFrame = null;

        WindowInstrumentsDb() {
            super(ClassicI18n.i18n.getMenuLabel("window.instrumentsDb"));
            this.putValue("ShortDescription", ClassicI18n.i18n.getMenuLabel("window.instrumentsDb.tt"));
            this.putValue("SmallIcon", Res.iconDb32);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!CC.verifyConnection()) {
                return;
            }
            if (CC.getInstrumentsDbTreeModel() == null) {
                String string = ClassicI18n.i18n.getMessage("A4n.noInstrumentsDbSupport!");
                HF.showErrorMessage(string, (Component)CC.getMainFrame());
                return;
            }
            if (this.instrumentsDbFrame != null && this.instrumentsDbFrame.isVisible()) {
                this.instrumentsDbFrame.setVisible(false);
                this.instrumentsDbFrame.setVisible(true);
                return;
            }
            this.instrumentsDbFrame = new InstrumentsDbFrame();
            this.instrumentsDbFrame.setVisible(true);
        }
    }

    private static class CloseChannelsTab
    extends AbstractAction {
        CloseChannelsTab() {
            super(ClassicI18n.i18n.getMenuLabel("tabs.close"));
            this.putValue("ShortDescription", ClassicI18n.i18n.getMenuLabel("ttCloseTab"));
            this.putValue("SmallIcon", Res.iconTabRemove22);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSMainFrame jSMainFrame = CC.getMainFrame();
            JSChannelsPane jSChannelsPane = jSMainFrame.getSelectedChannelsPane();
            if (jSChannelsPane.getChannelCount() > 0) {
                CloseTabDlg closeTabDlg = new CloseTabDlg(jSMainFrame);
                closeTabDlg.setVisible(true);
                if (closeTabDlg.isCancelled()) {
                    return;
                }
                JSChannel[] jSChannelArray = jSChannelsPane.getChannels();
                if (!closeTabDlg.remove()) {
                    JSChannelsPane jSChannelsPane2 = closeTabDlg.getSelectedChannelsPane();
                    for (JSChannel jSChannel : jSChannelArray) {
                        jSChannelsPane.removeChannel(jSChannel);
                    }
                    jSChannelsPane2.addChannels(jSChannelArray);
                    jSMainFrame.setSelectedChannelsPane(jSChannelsPane2);
                }
            }
            jSMainFrame.removeChannelsPane(jSChannelsPane);
        }
    }

    private static class MoveTab2End
    extends AbstractAction {
        MoveTab2End() {
            super(ClassicI18n.i18n.getMenuLabel("tabs.move2End"));
            this.putValue("ShortDescription", ClassicI18n.i18n.getMenuLabel("ttMoveTab2End"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ((MainFrame)CC.getMainFrame()).moveTab2End();
        }
    }

    private static class MoveTab2Right
    extends AbstractAction {
        MoveTab2Right() {
            super(ClassicI18n.i18n.getMenuLabel("tabs.move2Right"));
            this.putValue("ShortDescription", ClassicI18n.i18n.getMenuLabel("ttMoveTab2Right"));
            this.putValue("SmallIcon", Res.iconTabMoveRight22);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ((MainFrame)CC.getMainFrame()).moveTab2Right();
        }
    }

    private static class MoveTab2Left
    extends AbstractAction {
        MoveTab2Left() {
            super(ClassicI18n.i18n.getMenuLabel("tabs.move2Left"));
            this.putValue("ShortDescription", ClassicI18n.i18n.getMenuLabel("ttMoveTab2Left"));
            this.putValue("SmallIcon", Res.iconTabMoveLeft22);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ((MainFrame)CC.getMainFrame()).moveTab2Left();
        }
    }

    private static class MoveTab2Beginning
    extends AbstractAction {
        MoveTab2Beginning() {
            super(ClassicI18n.i18n.getMenuLabel("tabs.move2Beginning"));
            this.putValue("ShortDescription", ClassicI18n.i18n.getMenuLabel("ttMoveTab2Beginning"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ((MainFrame)CC.getMainFrame()).moveTab2Beginning();
        }
    }

    private static class EditTabTitle
    extends AbstractAction {
        EditTabTitle() {
            super(ClassicI18n.i18n.getMenuLabel("tabs.changeTitle"));
            this.putValue("ShortDescription", ClassicI18n.i18n.getMenuLabel("ttEditTabTitle"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new ChangeTabTitleDlg(CC.getMainFrame()).setVisible(true);
        }
    }

    private static class NewChannelsTab
    extends AbstractAction {
        NewChannelsTab() {
            super(ClassicI18n.i18n.getMenuLabel("tabs.new"));
            this.putValue("ShortDescription", ClassicI18n.i18n.getMenuLabel("ttNewTab"));
            this.putValue("SmallIcon", Res.iconTabNew22);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new NewChannelsTabDlg(CC.getMainFrame()).setVisible(true);
        }
    }

    public static class MoveChannelsTo
    extends AbstractAction
    implements PropertyChangeListener {
        private final JSChannelsPane pane;

        MoveChannelsTo(JSChannelsPane jSChannelsPane) {
            super(jSChannelsPane.getTitle());
            this.pane = jSChannelsPane;
            String string = ClassicI18n.i18n.getMenuLabel("ttMoveChannelsTo", jSChannelsPane.getTitle());
            this.putValue("ShortDescription", string);
            jSChannelsPane.addPropertyChangeListener("ChannelsPaneTitle", this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSChannel[] jSChannelArray;
            JSChannelsPane jSChannelsPane = CC.getMainFrame().getSelectedChannelsPane();
            for (JSChannel jSChannel : jSChannelArray = jSChannelsPane.getSelectedChannels()) {
                jSChannelsPane.removeChannel(jSChannel);
            }
            this.pane.addChannels(jSChannelArray);
            CC.getMainFrame().setSelectedChannelsPane(this.pane);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.putValue("Name", this.pane.getTitle());
            String string = ClassicI18n.i18n.getMenuLabel("ttMoveChannelsTo", this.pane.getTitle());
            this.putValue("ShortDescription", string);
        }

        public JSChannelsPane getChannelsPane() {
            return this.pane;
        }
    }

    private static class NewChannelWizard
    extends AbstractAction {
        NewChannelWizard() {
            super(ClassicI18n.i18n.getMenuLabel("channels.wizard"));
            this.putValue("ShortDescription", ClassicI18n.i18n.getMenuLabel("ttNewChannelWizard"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new org.jsampler.view.classic.NewChannelWizard().showWizard();
        }
    }

    private static class NewChannel
    extends AbstractAction {
        NewChannel() {
            super(ClassicI18n.i18n.getMenuLabel("channels.new"));
            this.putValue("ShortDescription", ClassicI18n.i18n.getMenuLabel("ttNewChannel"));
            this.putValue("SmallIcon", Res.iconNew24);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!A4n.verifyConnection()) {
                return;
            }
            CC.getSamplerModel().addBackendChannel();
        }
    }

    private static class Preferences
    extends AbstractAction {
        Preferences() {
            super(ClassicI18n.i18n.getMenuLabel("edit.preferences"));
            this.putValue("ShortDescription", ClassicI18n.i18n.getMenuLabel("ttPrefs"));
            this.putValue("SmallIcon", Res.iconPreferences32);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new PrefsDlg(CC.getMainFrame()).setVisible(true);
        }
    }

    private static class AddAudioDevice
    extends AbstractAction {
        AddAudioDevice() {
            super("");
            this.putValue("ShortDescription", ClassicI18n.i18n.getMenuLabel("ttAddAudioDevice"));
            this.putValue("SmallIcon", Res.iconNew16);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!A4n.verifyConnection()) {
                return;
            }
            new JSNewAudioDeviceDlg(CC.getMainFrame()).setVisible(true);
        }
    }

    private static class AddMidiDevice
    extends AbstractAction {
        AddMidiDevice() {
            super("");
            this.putValue("ShortDescription", ClassicI18n.i18n.getMenuLabel("ttAddMidiDevice"));
            this.putValue("SmallIcon", Res.iconNew16);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!A4n.verifyConnection()) {
                return;
            }
            new JSNewMidiDeviceDlg(CC.getMainFrame()).setVisible(true);
        }
    }

    private static class LoadLscpScript
    extends AbstractAction {
        LoadLscpScript() {
            super(ClassicI18n.i18n.getMenuLabel("actions.runScript"));
            this.putValue("ShortDescription", ClassicI18n.i18n.getMenuLabel("ttRunScript"));
            this.putValue("SmallIcon", Res.iconLoadScript32);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ((MainFrame)CC.getMainFrame()).runScript();
        }
    }

    private static class AddMidiInstrumentWizard
    extends AbstractAction {
        AddMidiInstrumentWizard() {
            super(ClassicI18n.i18n.getMenuLabel("actions.midiInstruments.newMidiInstrumentWizard"));
            String string = "actions.midiInstruments.newMidiInstrumentWizard.tt";
            this.putValue("ShortDescription", ClassicI18n.i18n.getMenuLabel(string));
            this.putValue("SmallIcon", Res.iconNew16);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ClassicPrefs classicPrefs = ClassicPrefs.preferences();
            JSNewMidiInstrumentWizard jSNewMidiInstrumentWizard = new JSNewMidiInstrumentWizard(Res.iconFolderOpen16);
            jSNewMidiInstrumentWizard.getWizardDialog().setResizable(false);
            if (classicPrefs.getBoolProperty("NewMidiInstrumentWizard.skip1")) {
                if (jSNewMidiInstrumentWizard.getModel().getCurrentPage() == null) {
                    jSNewMidiInstrumentWizard.getModel().next();
                }
                jSNewMidiInstrumentWizard.getModel().next();
            }
            jSNewMidiInstrumentWizard.showWizard();
        }
    }

    private static class RemoveMidiInstrumentMap
    extends AbstractAction {
        RemoveMidiInstrumentMap() {
            super(ClassicI18n.i18n.getMenuLabel("actions.midiInstruments.removeMap"));
            String string = ClassicI18n.i18n.getMenuLabel("actions.midiInstruments.removeMap.tt");
            this.putValue("ShortDescription", string);
            this.putValue("SmallIcon", Res.iconDelete16);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RemoveMidiInstrumentMapDlg removeMidiInstrumentMapDlg = new RemoveMidiInstrumentMapDlg();
            removeMidiInstrumentMapDlg.setVisible(true);
            if (removeMidiInstrumentMapDlg.isCancelled()) {
                return;
            }
            int n = removeMidiInstrumentMapDlg.getSelectedMap().getMapId();
            CC.getSamplerModel().removeBackendMidiInstrumentMap(n);
        }
    }

    private static class AddMidiInstrumentMap
    extends AbstractAction {
        AddMidiInstrumentMap() {
            super(ClassicI18n.i18n.getMenuLabel("actions.midiInstruments.addMap"));
            String string = ClassicI18n.i18n.getMenuLabel("actions.midiInstruments.addMap.tt");
            this.putValue("ShortDescription", string);
            this.putValue("SmallIcon", Res.iconNew16);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSAddMidiInstrumentMapDlg jSAddMidiInstrumentMapDlg = new JSAddMidiInstrumentMapDlg();
            jSAddMidiInstrumentMapDlg.setVisible(true);
            if (jSAddMidiInstrumentMapDlg.isCancelled()) {
                return;
            }
            CC.getSamplerModel().addBackendMidiInstrumentMap(jSAddMidiInstrumentMapDlg.getMapName());
            LeftPane.getLeftPane().showMidiInstrumentMapsPage();
        }
    }

    private static class SamplerInfo
    extends AbstractAction {
        SamplerInfo() {
            super(ClassicI18n.i18n.getMenuLabel("actions.samplerInfo"));
            this.putValue("ShortDescription", ClassicI18n.i18n.getMenuLabel("ttSamplerInfo"));
            this.putValue("SmallIcon", Res.iconInfo32);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new SamplerInfoDlg(CC.getMainFrame()).setVisible(true);
        }
    }
}

