/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileDocumentManager {
    @NotNull
    public static FileDocumentManager getInstance() {
        FileDocumentManager fileDocumentManager = ApplicationManager.getApplication().getService(FileDocumentManager.class);
        if (fileDocumentManager == null) {
            FileDocumentManager.$$$reportNull$$$0(0);
        }
        return fileDocumentManager;
    }

    @Nullable
    public abstract Document getDocument(@NotNull VirtualFile var1);

    @ApiStatus.Internal
    @ApiStatus.Experimental
    @Nullable
    public Document getDocument(@NotNull VirtualFile file2, @NotNull Project preferredProject) {
        if (file2 == null) {
            FileDocumentManager.$$$reportNull$$$0(1);
        }
        if (preferredProject == null) {
            FileDocumentManager.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        try (AccessToken ignored = ProjectLocator.withPreferredProject(file2, preferredProject);){
            Document document = this.getDocument(file2);
            return document;
        }
    }

    @Nullable
    public abstract Document getCachedDocument(@NotNull VirtualFile var1);

    @Nullable
    public abstract VirtualFile getFile(@NotNull Document var1);

    public abstract void saveDocument(@NotNull Document var1);

    public abstract void saveDocumentAsIs(@NotNull Document var1);

    public abstract boolean isDocumentUnsaved(@NotNull Document var1);

    public abstract void reloadFromDisk(@NotNull Document var1, @Nullable Project var2);

    @NotNull
    public abstract String getLineSeparator(@Nullable VirtualFile var1, @Nullable Project var2);

    @ApiStatus.Internal
    public void reloadBinaryFiles() {
    }

    @ApiStatus.Internal
    @Nullable
    public FileViewProvider findCachedPsiInAnyProject(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileDocumentManager.$$$reportNull$$$0(8);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/FileDocumentManager";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredProject";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/FileDocumentManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "requestWritingStatus";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reloadFromDisk";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "requestWritingStatus";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fileForDocumentCheckedOutSuccessfully";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findCachedPsiInAnyProject";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

