/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection.suppression;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiManager;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\nJ\b\u0010\u0011\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/gradle/codeInspection/suppression/GradleSuspendTypecheckingService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectsFailedToImport", "", "", "suspendHighlighting", "", "projectPath", "resumeHighlighting", "isSuspended", "", "dispose", "intellij.gradle.java"})
public final class GradleSuspendTypecheckingService
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final Set<String> projectsFailedToImport;

    public GradleSuspendTypecheckingService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.projectsFailedToImport = set;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void suspendHighlighting(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        this.projectsFailedToImport.add(projectPath);
    }

    public final void resumeHighlighting(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        PsiManager.getInstance((Project)this.project).dropResolveCaches();
        this.projectsFailedToImport.remove(projectPath);
    }

    public final boolean isSuspended(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return this.projectsFailedToImport.contains(projectPath);
    }

    public void dispose() {
        this.projectsFailedToImport.clear();
    }
}

