/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ToInfixCallIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "<init>", "()V", "isApplicableTo", "", "element", "caretOffset", "", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
public final class ToInfixCallIntention
extends SelfTargetingIntention<KtCallExpression> {
    public ToInfixCallIntention() {
        super(KtCallExpression.class, KotlinBundle.lazyMessage((String)"replace.with.infix.function.call", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtCallExpression element, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression ktExpression = element.getCalleeExpression();
        KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
        if (ktNameReferenceExpression == null) {
            return false;
        }
        KtNameReferenceExpression calleeExpr = ktNameReferenceExpression;
        if (!calleeExpr.getTextRange().containsOffset(caretOffset)) {
            return false;
        }
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)element));
        KtDotQualifiedExpression ktDotQualifiedExpression = ktQualifiedExpression instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)ktQualifiedExpression : null;
        if (ktDotQualifiedExpression == null) {
            return false;
        }
        KtDotQualifiedExpression dotQualified = ktDotQualifiedExpression;
        if (element.getTypeArgumentList() != null) {
            return false;
        }
        List list2 = element.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull((List)list2);
        if (ktValueArgument == null) {
            return false;
        }
        KtValueArgument argument2 = ktValueArgument;
        if (argument2.isNamed()) {
            return false;
        }
        if (argument2.getArgumentExpression() == null) {
            return false;
        }
        BindingContext bindingContext = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)element, BodyResolveMode.PARTIAL);
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)element), (BindingContext)bindingContext);
        if (resolvedCall == null) {
            return false;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor();
        FunctionDescriptor functionDescriptor = callableDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)callableDescriptor : null;
        if (functionDescriptor == null) {
            return false;
        }
        FunctionDescriptor function = functionDescriptor;
        if (!function.isInfix()) {
            return false;
        }
        return bindingContext.getType(dotQualified.getReceiverExpression()) != null;
    }

    @Override
    public void applyTo(@NotNull KtCallExpression element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getParent();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDotQualifiedExpression");
        KtDotQualifiedExpression dotQualified = (KtDotQualifiedExpression)psiElement;
        KtExpression receiver2 = dotQualified.getReceiverExpression();
        List list2 = element.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
        KtExpression ktExpression = ((KtValueArgument)CollectionsKt.single((List)list2)).getArgumentExpression();
        Intrinsics.checkNotNull((Object)ktExpression);
        KtExpression argument2 = ktExpression;
        KtExpression ktExpression2 = element.getCalleeExpression();
        Intrinsics.checkNotNull((Object)ktExpression2);
        String name2 = ktExpression2.getText();
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Object[] objectArray = new Object[]{receiver2, argument2};
        KtExpression newCall2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (String)("$0 " + name2 + " $1"), (Object[])objectArray, (boolean)false, (int)4, null);
        dotQualified.replace((PsiElement)newCall2);
    }
}

