/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0010R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaAnnotationsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationChecker;", "<init>", "()V", "javaToKotlinNameMap", "", "Lorg/jetbrains/kotlin/name/ClassId;", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;)V", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJavaAnnotationsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJavaAnnotationsChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaAnnotationsChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class FirJavaAnnotationsChecker
extends FirExpressionChecker<FirAnnotation> {
    @NotNull
    public static final FirJavaAnnotationsChecker INSTANCE = new FirJavaAnnotationsChecker();
    @NotNull
    private static final Map<ClassId, ClassId> javaToKotlinNameMap;

    private FirJavaAnnotationsChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirAnnotation expression) {
        FirArgumentList argumentList;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        FirBasedSymbol firBasedSymbol = (FirBasedSymbol)CollectionsKt.lastOrNull(context.getContainingDeclarations());
        if (!Intrinsics.areEqual((Object)(firBasedSymbol != null && (firBasedSymbol = firBasedSymbol.getSource()) != null ? firBasedSymbol.getKind() : null), (Object)KtRealSourceElementKind.INSTANCE)) {
            return;
        }
        ConeKotlinType annotationType = AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(FirTypeUtilsKt.getConeType(expression.getAnnotationTypeRef()));
        Object object = ConeTypeUtilsKt.getClassLikeLookupTagIfAny(annotationType);
        if (object == null || (object = ToSymbolUtilsKt.toClassSymbol((ConeClassLikeLookupTag)object, context.getSession())) == null) {
            return;
        }
        Object classSymbol = object;
        if (!(((FirBasedSymbol)classSymbol).getOrigin() instanceof FirDeclarationOrigin.Java)) {
            return;
        }
        ConeClassLikeLookupTag lookupTag = ((FirClassSymbol)classSymbol).toLookupTag();
        ClassId classId = javaToKotlinNameMap.get(lookupTag.getClassId());
        if (classId != null) {
            ClassId betterName = classId;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), FirJvmErrors.INSTANCE.getDEPRECATED_JAVA_ANNOTATION(), (Object)betterName.asSingleFqName(), null, (int)16, null);
        }
        if (expression instanceof FirAnnotationCall && (argumentList = ((FirAnnotationCall)expression).getArgumentList()) instanceof FirResolvedArgumentList) {
            Object object2 = ((FirResolvedArgumentList)argumentList).getOriginalArgumentList();
            if (object2 == null || (object2 = ((FirArgumentList)object2).getArguments()) == null) {
                return;
            }
            Object arguments2 = object2;
            Iterator iterator2 = arguments2.iterator();
            while (iterator2.hasNext()) {
                FirExpression key = (FirExpression)iterator2.next();
                if (key instanceof FirWrappedArgumentExpression) continue;
                FirValueParameter firValueParameter = ((FirResolvedArgumentList)argumentList).getMapping().get(key);
                Name it = firValueParameter != null ? firValueParameter.getName() : null;
                boolean bl = false;
                boolean bl2 = it != null && !Intrinsics.areEqual((Object)it, (Object)StandardClassIds.Annotations.ParameterNames.INSTANCE.getValue());
                if (!bl2) continue;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)key.getSource()), (KtDiagnosticFactory0)FirJvmErrors.INSTANCE.getPOSITIONED_VALUE_ARGUMENT_FOR_JAVA_ANNOTATION(), null, (int)8, null);
            }
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)JvmStandardClassIds.Annotations.Java.INSTANCE.getTarget(), (Object)StandardClassIds.Annotations.INSTANCE.getTarget()), TuplesKt.to((Object)JvmStandardClassIds.Annotations.Java.INSTANCE.getRetention(), (Object)StandardClassIds.Annotations.INSTANCE.getRetention()), TuplesKt.to((Object)JvmStandardClassIds.Annotations.Java.INSTANCE.getDeprecated(), (Object)StandardClassIds.Annotations.INSTANCE.getDeprecated()), TuplesKt.to((Object)JvmStandardClassIds.Annotations.Java.INSTANCE.getDocumented(), (Object)StandardClassIds.Annotations.INSTANCE.getMustBeDocumented())};
        javaToKotlinNameMap = MapsKt.mapOf((Pair[])pairArray);
    }
}

