/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl;

import java.util.Map;
import java.util.TreeMap;
import jetbrains.coverage.report.CoverageStatistics;
import jetbrains.coverage.report.Entry;
import jetbrains.coverage.report.StatEntry;
import org.jetbrains.annotations.Nullable;

public class CoverageStatisticsBean
implements CoverageStatistics {
    private Map<String, Counter> myValues = new TreeMap<String, Counter>();
    private CoverageStatistics myPrevStats;
    private static final String TOTAL_CLASSES = "classes-total";
    private static final String COVERED_CLASSES = "classes-covered";
    private static final String TOTAL_METHODS = "methods-total";
    private static final String COVERED_METHODS = "methods-covered";
    private static final String TOTAL_LINES = "lines-total";
    private static final String COVERED_LINES = "lines-covered";
    private static final String TOTAL_BLOCKS = "blocks-total";
    private static final String COVERED_BLOCKS = "blocks-covered";
    private static final String TOTAL_STATEMENTS = "statements-total";
    private static final String COVERED_STATEMENTS = "statements-covered";
    private static final CoverageStatistics NULL_STATS = new CoverageStatistics(){

        public StatEntry getClassStats() {
            return null;
        }

        public StatEntry getMethodStats() {
            return null;
        }

        public StatEntry getBlockStats() {
            return null;
        }

        public StatEntry getLineStats() {
            return null;
        }

        public StatEntry getStatementStats() {
            return null;
        }
    };

    public CoverageStatisticsBean(@Nullable CoverageStatistics prevStats) {
        this.myValues.put(TOTAL_CLASSES, new Counter(-1));
        this.myValues.put(TOTAL_METHODS, new Counter(-1));
        this.myValues.put(TOTAL_BLOCKS, new Counter(-1));
        this.myValues.put(TOTAL_LINES, new Counter(-1));
        this.myValues.put(TOTAL_STATEMENTS, new Counter(-1));
        this.myValues.put(COVERED_CLASSES, new Counter(-1));
        this.myValues.put(COVERED_METHODS, new Counter(-1));
        this.myValues.put(COVERED_BLOCKS, new Counter(-1));
        this.myValues.put(COVERED_LINES, new Counter(-1));
        this.myValues.put(COVERED_STATEMENTS, new Counter(-1));
        this.myPrevStats = prevStats != null ? prevStats : NULL_STATS;
    }

    public void incrementTotalClasses(int count) {
        this.incrementKey(TOTAL_CLASSES, count);
    }

    public void incrementCoveredClasses(int count) {
        this.incrementKey(COVERED_CLASSES, count);
    }

    public void incrementMethods(@Nullable Entry e) {
        if (e == null) {
            return;
        }
        this.incrementTotalMethods(e.getTotal());
        this.incrementCoveredMethods(e.getCovered());
    }

    public void incrementBlocks(@Nullable Entry e) {
        if (e == null || e.getTotal() <= 0) {
            return;
        }
        this.incrementTotalBlocks(e.getTotal());
        this.incrementCoveredBlocks(e.getCovered());
    }

    public void incrementLines(@Nullable Entry e) {
        if (e == null || e.getTotal() <= 0) {
            return;
        }
        this.incrementTotalLines(e.getTotal());
        this.incrementCoveredLines(e.getCovered());
    }

    public void incrementStatements(@Nullable Entry e) {
        if (e == null || e.getTotal() <= 0) {
            return;
        }
        this.incrementTotalStatements(e.getTotal());
        this.incrementCoveredStatements(e.getCovered());
    }

    public void incrementTotalMethods(int count) {
        this.incrementKey(TOTAL_METHODS, count);
    }

    public void incrementCoveredMethods(int count) {
        this.incrementKey(COVERED_METHODS, count);
    }

    public void incrementTotalBlocks(int count) {
        this.incrementKey(TOTAL_BLOCKS, count);
    }

    public void incrementCoveredBlocks(int count) {
        this.incrementKey(COVERED_BLOCKS, count);
    }

    public void incrementTotalLines(int count) {
        this.incrementKey(TOTAL_LINES, count);
    }

    public void incrementCoveredLines(int count) {
        this.incrementKey(COVERED_LINES, count);
    }

    public void incrementCoveredStatements(int count) {
        this.incrementKey(COVERED_STATEMENTS, count);
    }

    public void incrementTotalStatements(int count) {
        this.incrementKey(TOTAL_STATEMENTS, count);
    }

    private void incrementKey(String key, int count) {
        if (count < 0) {
            return;
        }
        Counter cnt = this.myValues.get(key);
        if (cnt.value() < 0) {
            cnt.set(0);
        }
        cnt.increment(count);
    }

    private int value(String key) {
        return this.myValues.get(key).value();
    }

    public StatEntry getClassStats() {
        return new StatEntry(this.value(TOTAL_CLASSES), this.value(COVERED_CLASSES), this.myPrevStats.getClassStats());
    }

    public StatEntry getMethodStats() {
        return new StatEntry(this.value(TOTAL_METHODS), this.value(COVERED_METHODS), this.myPrevStats.getMethodStats());
    }

    public StatEntry getBlockStats() {
        return new StatEntry(this.value(TOTAL_BLOCKS), this.value(COVERED_BLOCKS), this.myPrevStats.getBlockStats());
    }

    public StatEntry getLineStats() {
        return new StatEntry(this.value(TOTAL_LINES), this.value(COVERED_LINES), this.myPrevStats.getLineStats());
    }

    public StatEntry getStatementStats() {
        return new StatEntry(this.value(TOTAL_STATEMENTS), this.value(COVERED_STATEMENTS), this.myPrevStats.getStatementStats());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        for (Map.Entry<String, Counter> entry : this.myValues.entrySet()) {
            sb.append(entry.getKey()).append(" => ").append(entry.getValue()).append("\n");
        }
        return "CoverageStatisticsBean{" + sb + '}';
    }

    private static class Counter {
        private int myCounter;

        private Counter(int counter) {
            this.myCounter = counter;
        }

        public void set(int val) {
            this.myCounter = val;
        }

        public int value() {
            return this.myCounter;
        }

        public void increment(int count) {
            this.myCounter += count;
        }

        public String toString() {
            return "Counter: " + this.myCounter;
        }
    }
}

