/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.api.GraphElementsController;
import org.gephi.datalab.spi.rows.merge.AttributeRowsMergeStrategy;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Table;
import org.openide.util.Lookup;

public class GraphElementsControllerImpl
implements GraphElementsController {
    private static final float DEFAULT_NODE_SIZE = 10.0f;
    private static final float DEFAULT_EDGE_WEIGHT = 1.0f;

    @Override
    public Node createNode(String label) {
        return this.createNode(label, this.getCurrentGraph());
    }

    @Override
    public Node createNode(String label, Graph graph) {
        Node newNode = this.buildNode(graph, label);
        graph.addNode(newNode);
        return newNode;
    }

    @Override
    public Node createNode(String label, String id) {
        return this.createNode(label, id, this.getCurrentGraph());
    }

    @Override
    public Node createNode(String label, String id, Graph graph) {
        if (graph.getNode((Object)id) == null) {
            Node newNode = this.buildNode(graph, label, id);
            graph.addNode(newNode);
            return newNode;
        }
        return null;
    }

    @Override
    public Node duplicateNode(Node node) {
        Graph g = this.getCurrentGraph();
        Node copy = this.copyNode(node, g);
        return copy;
    }

    @Override
    public void duplicateNodes(Node[] nodes) {
        for (Node n : nodes) {
            this.duplicateNode(n);
        }
    }

    @Override
    public Edge createEdge(Node source, Node target, boolean directed) {
        return this.createEdge((String)null, source, target, directed, this.getCurrentGraph());
    }

    @Override
    public Edge createEdge(Node source, Node target, boolean directed, Graph graph) {
        return this.createEdge((String)null, source, target, directed, graph);
    }

    @Override
    public Edge createEdge(String id, Node source, Node target, boolean directed) {
        return this.createEdge(id, source, target, directed, this.getCurrentGraph());
    }

    @Override
    public Edge createEdge(Node source, Node target, boolean directed, Object typeLabel) {
        return this.createEdge(null, source, target, directed, typeLabel, this.getCurrentGraph());
    }

    @Override
    public Edge createEdge(Node source, Node target, boolean directed, Object typeLabel, Graph graph) {
        return this.createEdge(null, source, target, directed, typeLabel, graph);
    }

    @Override
    public Edge createEdge(String id, Node source, Node target, boolean directed, Object typeLabel) {
        return this.createEdge(id, source, target, directed, typeLabel, this.getCurrentGraph());
    }

    @Override
    public Edge createEdge(String id, Node source, Node target, boolean directed, Graph graph) {
        return this.createEdge(id, source, target, directed, null, graph);
    }

    @Override
    public Edge createEdge(String id, Node source, Node target, boolean directed, Object typeLabel, Graph graph) {
        Edge newEdge = this.buildEdge(graph, id, source, target, directed, typeLabel);
        try {
            if (graph.addEdge(newEdge)) {
                return newEdge;
            }
        }
        catch (Exception e) {
            Logger.getLogger("").log(Level.SEVERE, "Error when adding edge [id = {0}, source = {1}, target = {2}, directed = {3}, typeLabel = {4}] to the graph. Exception message: {5}", new Object[]{id, source.getId(), target.getId(), directed, typeLabel, e.getMessage()});
        }
        return null;
    }

    @Override
    public void createEdges(Node source, Node[] allNodes, boolean directed) {
        for (Node n : allNodes) {
            if (n == source) continue;
            this.createEdge(source, n, directed);
        }
    }

    @Override
    public void deleteNode(Node node) {
        this.removeNode(node, this.getCurrentGraph());
    }

    @Override
    public void deleteNodes(Node[] nodes) {
        Graph graph = this.getCurrentGraph();
        for (Node node : nodes) {
            this.removeNode(node, graph);
        }
    }

    @Override
    public void deleteEdge(Edge edge) {
        this.removeEdge(edge, this.getCurrentGraph());
    }

    @Override
    public void deleteEdges(Edge[] edges) {
        Graph graph = this.getCurrentGraph();
        for (Edge edge : edges) {
            this.removeEdge(edge, graph);
        }
    }

    @Override
    public void deleteEdgeWithNodes(Edge edge, boolean deleteSource, boolean deleteTarget) {
        if (deleteSource) {
            this.deleteNode(edge.getSource());
        }
        if (deleteTarget) {
            this.deleteNode(edge.getTarget());
        }
        this.removeEdge(edge, this.getCurrentGraph());
    }

    @Override
    public void deleteEdgesWithNodes(Edge[] edges, boolean deleteSource, boolean deleteTarget) {
        for (Edge edge : edges) {
            this.deleteEdgeWithNodes(edge, deleteSource, deleteTarget);
        }
    }

    @Override
    public Node mergeNodes(Graph graph, Node[] nodes, Node selectedNode, Column[] columns, AttributeRowsMergeStrategy[] mergeStrategies, boolean deleteMergedNodes) {
        Table edgesTable = graph.getModel().getEdgeTable();
        if (selectedNode == null) {
            selectedNode = nodes[0];
        }
        Node newNode = this.createNode("", null, graph);
        newNode.setX(selectedNode.x());
        newNode.setY(selectedNode.y());
        newNode.setZ(selectedNode.z());
        newNode.setSize(selectedNode.size());
        newNode.setR(selectedNode.r());
        newNode.setG(selectedNode.g());
        newNode.setB(selectedNode.b());
        newNode.setAlpha(selectedNode.alpha());
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        ac.mergeRowsValues(columns, mergeStrategies, (Element[])nodes, (Element)selectedNode, (Element)newNode);
        HashSet<Node> nodesSet = new HashSet<Node>();
        nodesSet.addAll(Arrays.asList(nodes));
        for (Node node : nodes) {
            for (Edge edge : this.getNodeEdges(node)) {
                Edge newEdge;
                Node newEdgeTarget;
                Node newEdgeSource;
                if (edge.getSource() == node) {
                    newEdgeSource = newNode;
                    newEdgeTarget = nodesSet.contains(edge.getTarget()) ? newNode : edge.getTarget();
                } else {
                    newEdgeTarget = newNode;
                    newEdgeSource = nodesSet.contains(edge.getSource()) ? newNode : edge.getSource();
                }
                if (graph.getEdge(newEdgeSource, newEdgeTarget) != null || (newEdge = this.createEdge(newEdgeSource, newEdgeTarget, edge.isDirected(), edge.getTypeLabel(), graph)) == null) continue;
                for (Column column : edgesTable) {
                    if (column.isReadOnly()) continue;
                    Object value = edge.getAttribute(column);
                    if (value == null) {
                        newEdge.removeAttribute(column);
                        continue;
                    }
                    newEdge.setAttribute(column, edge.getAttribute(column));
                }
            }
        }
        if (deleteMergedNodes) {
            this.deleteNodes(nodes);
        }
        return newNode;
    }

    @Override
    public void setNodeFixed(Node node, boolean fixed) {
        node.setFixed(fixed);
    }

    @Override
    public void setNodesFixed(Node[] nodes, boolean fixed) {
        for (Node n : nodes) {
            this.setNodeFixed(n, fixed);
        }
    }

    @Override
    public boolean isNodeFixed(Node node) {
        return node.isFixed();
    }

    @Override
    public Node[] getNodeNeighbours(Node node) {
        return this.getCurrentGraph().getNeighbors(node).toArray();
    }

    @Override
    public Edge[] getNodeEdges(Node node) {
        return this.getCurrentGraph().getEdges(node).toArray();
    }

    @Override
    public int getNodesCount() {
        Graph graph = this.getCurrentGraph();
        return graph.getNodeCount();
    }

    @Override
    public int getEdgesCount() {
        Graph graph = this.getCurrentGraph();
        return graph.getEdgeCount();
    }

    @Override
    public boolean isNodeInGraph(Node node) {
        return this.getCurrentGraph().contains(node);
    }

    @Override
    public boolean areNodesInGraph(Node[] nodes) {
        Graph graph = this.getCurrentGraph();
        for (Node n : nodes) {
            if (graph.contains(n)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEdgeInGraph(Edge edge) {
        return this.getCurrentGraph().contains(edge);
    }

    @Override
    public boolean areEdgesInGraph(Edge[] edges) {
        Graph graph = this.getCurrentGraph();
        for (Edge e : edges) {
            if (graph.contains(e)) continue;
            return false;
        }
        return true;
    }

    private Graph getCurrentGraph() {
        return ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getGraph();
    }

    private Node buildNode(Graph graph, String label) {
        return this.buildNode(graph, label, null);
    }

    private Node buildNode(Graph graph, String label, String id) {
        Node newNode = id != null ? graph.getModel().factory().newNode((Object)id) : graph.getModel().factory().newNode();
        newNode.setSize(10.0f);
        newNode.setLabel(label);
        newNode.setX((float)((0.01 + Math.random()) * 1000.0) - 500.0f);
        newNode.setY((float)((0.01 + Math.random()) * 1000.0) - 500.0f);
        return newNode;
    }

    private Edge buildEdge(Graph graph, String id, Node source, Node target, boolean directed, Object typeLabel) {
        int type = typeLabel == null ? graph.getModel().getEdgeType(null) : graph.getModel().addEdgeType(typeLabel);
        Edge newEdge = id != null ? graph.getModel().factory().newEdge((Object)id, source, target, type, 1.0, directed) : graph.getModel().factory().newEdge(source, target, type, 1.0, directed);
        return newEdge;
    }

    private Node copyNode(Node node, Graph graph) {
        Node copy = this.buildNode(graph, node.getLabel());
        copy.setX(node.x());
        copy.setY(node.y());
        copy.setZ(node.z());
        copy.setSize(node.size());
        copy.setR(node.r());
        copy.setG(node.g());
        copy.setB(node.b());
        copy.setAlpha(node.alpha());
        Table nodeTable = graph.getModel().getNodeTable();
        for (Column column : nodeTable) {
            if (column.isReadOnly()) continue;
            copy.setAttribute(column, node.getAttribute(column));
        }
        graph.addNode(copy);
        return copy;
    }

    private void removeNode(Node node, Graph graph) {
        graph.removeNode(node);
    }

    private void removeEdge(Edge edge, Graph graph) {
        graph.removeEdge(edge);
    }
}

