/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.sentry.ISerializer;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEnvelopeHeader;
import io.sentry.SentryEnvelopeHeaderAdapter;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryEnvelopeItemHeader;
import io.sentry.SentryEnvelopeItemHeaderAdapter;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.Session;
import io.sentry.SessionAdapter;
import io.sentry.SpanId;
import io.sentry.SpanStatus;
import io.sentry.UnknownPropertiesTypeAdapterFactory;
import io.sentry.adapters.CollectionAdapter;
import io.sentry.adapters.ContextsDeserializerAdapter;
import io.sentry.adapters.ContextsSerializerAdapter;
import io.sentry.adapters.DateDeserializerAdapter;
import io.sentry.adapters.DateSerializerAdapter;
import io.sentry.adapters.MapAdapter;
import io.sentry.adapters.OrientationDeserializerAdapter;
import io.sentry.adapters.OrientationSerializerAdapter;
import io.sentry.adapters.SentryIdDeserializerAdapter;
import io.sentry.adapters.SentryIdSerializerAdapter;
import io.sentry.adapters.SentryLevelDeserializerAdapter;
import io.sentry.adapters.SentryLevelSerializerAdapter;
import io.sentry.adapters.SpanIdDeserializerAdapter;
import io.sentry.adapters.SpanIdSerializerAdapter;
import io.sentry.adapters.SpanStatusDeserializerAdapter;
import io.sentry.adapters.SpanStatusSerializerAdapter;
import io.sentry.adapters.TimeZoneDeserializerAdapter;
import io.sentry.adapters.TimeZoneSerializerAdapter;
import io.sentry.protocol.Contexts;
import io.sentry.protocol.Device;
import io.sentry.protocol.SentryId;
import io.sentry.util.Objects;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GsonSerializer
implements ISerializer {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final Gson gson;

    public GsonSerializer(@NotNull SentryOptions options) {
        this.options = Objects.requireNonNull(options, "The SentryOptions object is required.");
        this.gson = this.provideGson();
    }

    @NotNull
    private Gson provideGson() {
        return new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(SentryId.class, (Object)new SentryIdSerializerAdapter(this.options)).registerTypeAdapter(SentryId.class, (Object)new SentryIdDeserializerAdapter(this.options)).registerTypeAdapter(Date.class, (Object)new DateSerializerAdapter(this.options)).registerTypeAdapter(Date.class, (Object)new DateDeserializerAdapter(this.options)).registerTypeAdapter(TimeZone.class, (Object)new TimeZoneSerializerAdapter(this.options)).registerTypeAdapter(TimeZone.class, (Object)new TimeZoneDeserializerAdapter(this.options)).registerTypeAdapter(Device.DeviceOrientation.class, (Object)new OrientationSerializerAdapter(this.options)).registerTypeAdapter(Device.DeviceOrientation.class, (Object)new OrientationDeserializerAdapter(this.options)).registerTypeAdapter(SentryLevel.class, (Object)new SentryLevelSerializerAdapter(this.options)).registerTypeAdapter(SentryLevel.class, (Object)new SentryLevelDeserializerAdapter(this.options)).registerTypeAdapter(Contexts.class, (Object)new ContextsDeserializerAdapter(this.options)).registerTypeAdapter(Contexts.class, (Object)new ContextsSerializerAdapter(this.options)).registerTypeAdapterFactory(UnknownPropertiesTypeAdapterFactory.get()).registerTypeAdapter(SentryEnvelopeHeader.class, (Object)new SentryEnvelopeHeaderAdapter()).registerTypeAdapter(SentryEnvelopeItemHeader.class, (Object)new SentryEnvelopeItemHeaderAdapter()).registerTypeAdapter(Session.class, (Object)new SessionAdapter(this.options)).registerTypeAdapter(SpanId.class, (Object)new SpanIdDeserializerAdapter(this.options)).registerTypeAdapter(SpanId.class, (Object)new SpanIdSerializerAdapter(this.options)).registerTypeAdapter(SpanStatus.class, (Object)new SpanStatusDeserializerAdapter(this.options)).registerTypeAdapter(SpanStatus.class, (Object)new SpanStatusSerializerAdapter(this.options)).registerTypeHierarchyAdapter(Collection.class, (Object)new CollectionAdapter()).registerTypeHierarchyAdapter(Map.class, (Object)new MapAdapter()).disableHtmlEscaping().create();
    }

    @Override
    @Nullable
    public <T> T deserialize(@NotNull Reader reader, @NotNull Class<T> clazz) {
        Objects.requireNonNull(reader, "The Reader object is required.");
        Objects.requireNonNull(clazz, "The Class type is required.");
        return (T)this.gson.fromJson(reader, clazz);
    }

    @Override
    @Nullable
    public SentryEnvelope deserializeEnvelope(@NotNull InputStream inputStream) {
        Objects.requireNonNull(inputStream, "The InputStream object is required.");
        try {
            return this.options.getEnvelopeReader().read(inputStream);
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error deserializing envelope.", e);
            return null;
        }
    }

    @Override
    public <T> void serialize(@NotNull T entity, @NotNull Writer writer) throws IOException {
        Objects.requireNonNull(entity, "The entity is required.");
        Objects.requireNonNull(writer, "The Writer object is required.");
        if (this.options.getLogger().isEnabled(SentryLevel.DEBUG)) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Serializing object: %s", this.gson.toJson(entity));
        }
        this.gson.toJson(entity, entity.getClass(), (Appendable)writer);
        writer.flush();
    }

    @Override
    public void serialize(@NotNull SentryEnvelope envelope, @NotNull OutputStream outputStream) throws Exception {
        Objects.requireNonNull(envelope, "The SentryEnvelope object is required.");
        Objects.requireNonNull(outputStream, "The Stream object is required.");
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)bufferedOutputStream, UTF_8));){
            this.gson.toJson((Object)envelope.getHeader(), SentryEnvelopeHeader.class, (Appendable)writer);
            writer.write("\n");
            for (SentryEnvelopeItem item : envelope.getItems()) {
                try {
                    byte[] data = item.getData();
                    this.gson.toJson((Object)item.getHeader(), SentryEnvelopeItemHeader.class, (Appendable)writer);
                    writer.write("\n");
                    ((Writer)writer).flush();
                    outputStream.write(data);
                    writer.write("\n");
                }
                catch (Throwable exception) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Failed to create envelope item. Dropping it.", exception);
                }
            }
            ((Writer)writer).flush();
        }
    }

    @Override
    @NotNull
    public String serialize(@NotNull Map<String, Object> data) throws Exception {
        Objects.requireNonNull(data, "The SentryEnvelope object is required.");
        return this.gson.toJson(data);
    }
}

