/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.collection.ExtendedComboBoxModel;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.filter.condition.DefaultConditionRenderer;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.icon.IconContainedCondition;
import org.freeplane.features.icon.IconExistsCondition;
import org.freeplane.features.icon.IconRegistry;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.TagCompareCondition;
import org.freeplane.features.icon.TagContainsCondition;
import org.freeplane.features.icon.TagMatchesCondition;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.mode.Controller;
import org.freeplane.n3.nanoxml.XMLElement;

class IconConditionController
implements IElementaryConditionController {
    static final String FILTER_ICON = "filter_icon";
    static final String FILTER_TAG = "filter_tag";
    static final String FILTER_EXTENDED_TAG_CATEGORY = "filter_tag_category";

    @Override
    public boolean canEditValues(Object property, TranslatedObject simpleCond) {
        TranslatedObject o = (TranslatedObject)property;
        return o.objectEquals(FILTER_TAG) || o.objectEquals(FILTER_EXTENDED_TAG_CATEGORY);
    }

    @Override
    public boolean canHandle(Object selectedItem) {
        if (!(selectedItem instanceof TranslatedObject)) {
            return false;
        }
        TranslatedObject namedObject = (TranslatedObject)selectedItem;
        return namedObject.objectEquals(FILTER_ICON) || namedObject.objectEquals(FILTER_TAG) || namedObject.objectEquals(FILTER_EXTENDED_TAG_CATEGORY);
    }

    @Override
    public boolean canSelectValues(Object property, TranslatedObject simpleCond) {
        return !simpleCond.objectEquals(ConditionFactory.FILTER_EXIST);
    }

    @Override
    public ASelectableCondition createCondition(Object selectedItem, TranslatedObject simpleCondition, Object value, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        boolean searchesAcrossAllCategories;
        TranslatedObject namedObject = (TranslatedObject)selectedItem;
        if (namedObject.objectEquals(FILTER_ICON)) {
            if (simpleCondition.objectEquals(ConditionFactory.FILTER_CONTAINS)) {
                return value instanceof UIIcon ? new IconContainedCondition(((UIIcon)value).getName()) : null;
            }
            if (simpleCondition.objectEquals(ConditionFactory.FILTER_EXIST)) {
                return new IconExistsCondition();
            }
        }
        if ((searchesAcrossAllCategories = namedObject.objectEquals(FILTER_EXTENDED_TAG_CATEGORY)) || namedObject.objectEquals(FILTER_TAG)) {
            String comparedString;
            String string = comparedString = value instanceof Tag ? ((Tag)value).getContent() : value.toString();
            if (simpleCondition.objectEquals(ConditionFactory.FILTER_IS_EQUAL_TO)) {
                return new TagCompareCondition(comparedString, matchCase, 0, true, matchApproximately, ignoreDiacritics, searchesAcrossAllCategories);
            }
            if (simpleCondition.objectEquals(ConditionFactory.FILTER_IS_NOT_EQUAL_TO)) {
                return new TagCompareCondition(comparedString, matchCase, 0, false, matchApproximately, ignoreDiacritics, searchesAcrossAllCategories);
            }
            if (simpleCondition.objectEquals(ConditionFactory.FILTER_GT)) {
                return new TagCompareCondition(comparedString, matchCase, 1, true, false, ignoreDiacritics, searchesAcrossAllCategories);
            }
            if (simpleCondition.objectEquals(ConditionFactory.FILTER_GE)) {
                return new TagCompareCondition(comparedString, matchCase, -1, false, false, ignoreDiacritics, searchesAcrossAllCategories);
            }
            if (simpleCondition.objectEquals(ConditionFactory.FILTER_LT)) {
                return new TagCompareCondition(comparedString, matchCase, -1, true, false, ignoreDiacritics, searchesAcrossAllCategories);
            }
            if (simpleCondition.objectEquals(ConditionFactory.FILTER_LE)) {
                return new TagCompareCondition(comparedString, matchCase, 1, false, false, ignoreDiacritics, searchesAcrossAllCategories);
            }
            if (simpleCondition.objectEquals(ConditionFactory.FILTER_REGEXP)) {
                return new TagMatchesCondition(comparedString.toString(), matchCase, searchesAcrossAllCategories);
            }
            if (simpleCondition.objectEquals(ConditionFactory.FILTER_CONTAINS)) {
                return new TagContainsCondition(comparedString, matchCase, matchApproximately, false, ignoreDiacritics, searchesAcrossAllCategories);
            }
            if (simpleCondition.objectEquals(ConditionFactory.FILTER_CONTAINS_WORDWISE)) {
                return new TagContainsCondition(comparedString, matchCase, matchApproximately, true, ignoreDiacritics, searchesAcrossAllCategories);
            }
        }
        return null;
    }

    @Override
    public ComboBoxModel getConditionsForProperty(Object property) {
        TranslatedObject namedObject = (TranslatedObject)property;
        if (namedObject.objectEquals(FILTER_ICON)) {
            return new DefaultComboBoxModel<Object>(this.getIconConditionNames());
        }
        if (namedObject.objectEquals(FILTER_TAG) || namedObject.objectEquals(FILTER_EXTENDED_TAG_CATEGORY)) {
            return new DefaultComboBoxModel<Object>(this.getTagConditionNames());
        }
        throw new IllegalArgumentException(String.valueOf(property));
    }

    @Override
    public ListModel getFilteredProperties() {
        DefaultListModel<TranslatedObject> list = new DefaultListModel<TranslatedObject>();
        list.addElement(TextUtils.createTranslatedString(FILTER_ICON));
        list.addElement(TextUtils.createTranslatedString(FILTER_TAG));
        list.addElement(TextUtils.createTranslatedString(FILTER_EXTENDED_TAG_CATEGORY));
        return list;
    }

    public Object[] getIconConditionNames() {
        return new TranslatedObject[]{TextUtils.createTranslatedString(ConditionFactory.FILTER_CONTAINS), TextUtils.createTranslatedString(ConditionFactory.FILTER_EXIST)};
    }

    public Object[] getTagConditionNames() {
        return new TranslatedObject[]{TextUtils.createTranslatedString(ConditionFactory.FILTER_CONTAINS), TextUtils.createTranslatedString(ConditionFactory.FILTER_CONTAINS_WORDWISE), TextUtils.createTranslatedString(ConditionFactory.FILTER_REGEXP), TextUtils.createTranslatedString(ConditionFactory.FILTER_IS_EQUAL_TO), TextUtils.createTranslatedString(ConditionFactory.FILTER_IS_NOT_EQUAL_TO), TranslatedObject.literal(ConditionFactory.FILTER_GT), TranslatedObject.literal(ConditionFactory.FILTER_GE), TranslatedObject.literal(ConditionFactory.FILTER_LE), TranslatedObject.literal(ConditionFactory.FILTER_LT)};
    }

    @Override
    public ComboBoxEditor getValueEditor(Object selectedProperty, TranslatedObject selectedCondition) {
        return null;
    }

    @Override
    public ComboBoxModel getValuesForProperty(Object property, TranslatedObject simpleCond) {
        ExtendedComboBoxModel extendedComboBoxModel = new ExtendedComboBoxModel();
        TranslatedObject namedObject = (TranslatedObject)property;
        IconRegistry iconRegistry = Controller.getCurrentController().getMap().getIconRegistry();
        if (namedObject.objectEquals(FILTER_ICON)) {
            extendedComboBoxModel.setExtensionList(iconRegistry.getIconsAsListModel());
        } else if (namedObject.objectEquals(FILTER_TAG) || namedObject.objectEquals(FILTER_EXTENDED_TAG_CATEGORY)) {
            extendedComboBoxModel.setExtensionList(iconRegistry.getTagCategories().getTagsAsListModel());
        }
        return extendedComboBoxModel;
    }

    @Override
    public boolean isCaseDependent(Object property, TranslatedObject simpleCond) {
        return this.checksTag(property);
    }

    @Override
    public boolean supportsApproximateMatching(Object property, TranslatedObject simpleCond) {
        return this.checksTag(property);
    }

    private boolean checksTag(Object property) {
        TranslatedObject namedObject = (TranslatedObject)property;
        return !namedObject.objectEquals(FILTER_ICON);
    }

    @Override
    public ASelectableCondition loadCondition(XMLElement element) {
        if (element.getName().equalsIgnoreCase("icon_contained_condition")) {
            return IconContainedCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("icon_exists_condition")) {
            return IconExistsCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("tag_compare_condition")) {
            return TagCompareCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("tag_matches_condition")) {
            return TagMatchesCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("tag_contains_condition")) {
            return TagContainsCondition.load(element);
        }
        return null;
    }

    @Override
    public ListCellRenderer getValueRenderer(Object selectedProperty, TranslatedObject selectedCondition) {
        return new DefaultConditionRenderer("", true);
    }
}

