/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedureParameter;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.DBPObjectWithLazyDescription;
import org.jkiss.dbeaver.model.DBPOverloadedObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreAggregate
implements PostgreObject,
DBPOverloadedObject,
DBPObjectWithLazyDescription {
    private long oid;
    private final PostgreSchema schema;
    private String name;
    private boolean persisted;
    private PostgreProcedure function;

    public PostgreAggregate(DBRProgressMonitor monitor, PostgreSchema schema, ResultSet dbResult) throws SQLException, DBException {
        this.schema = schema;
        this.loadInfo(monitor, dbResult);
    }

    private void loadInfo(DBRProgressMonitor monitor, ResultSet dbResult) throws SQLException, DBException {
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"proc_oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"proc_name");
        this.function = this.schema.getProcedure(monitor, this.oid);
        this.persisted = true;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public List<PostgreDataType> getInputTypes(DBRProgressMonitor monitor) throws DBException {
        if (this.function == null) {
            return null;
        }
        ArrayList<PostgreDataType> result = new ArrayList<PostgreDataType>();
        for (PostgreProcedureParameter param : this.function.getInputParameters()) {
            result.add(param.getParameterType());
        }
        return result;
    }

    @Property(viewable=true, order=3)
    public PostgreDataType getOutputType(DBRProgressMonitor monitor) throws DBException {
        return this.function == null ? null : this.function.getReturnType();
    }

    @Property(viewable=false, order=80)
    public long getObjectId() {
        return this.oid;
    }

    @Property(viewable=true, order=10)
    public PostgreProcedure getFunction() throws DBException {
        return this.function;
    }

    public DBSObject getParentObject() {
        return this.schema;
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return this.schema.getDataSource();
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return this.schema.getDatabase();
    }

    public String getDescription() {
        return null;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=100)
    public String getDescription(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.function == null ? null : this.function.getDescription();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    @NotNull
    public String getOverloadedName() {
        return this.function == null ? this.name : PostgreProcedure.makeOverloadedName(this.schema, this.name, this.function.getInputParameters(), true, false, false);
    }
}

