/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.net.ssh.jsch;

import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import org.eclipse.jsch.ui.UserInfoPrompter;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.net.ssh.JSCHUserInfoPromptProvider;
import org.jkiss.dbeaver.model.net.ssh.config.SSHAuthConfiguration;
import org.jkiss.dbeaver.model.net.ssh.config.SSHHostConfiguration;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.net.ssh.SSHUIMessages;
import org.jkiss.utils.CommonUtils;

public class JSCHUIPromptProvider
implements JSCHUserInfoPromptProvider {
    @NotNull
    public UserInfo createUserInfoPrompt(@NotNull SSHHostConfiguration configuration, @NotNull Session session) {
        return new UIPrompter(configuration, session);
    }

    private static class UIPrompter
    extends UserInfoPrompter {
        private static final Log log = Log.getLog(JSCHUIPromptProvider.class);
        private final SSHHostConfiguration configuration;

        UIPrompter(@NotNull SSHHostConfiguration configuration, Session session) {
            super(session);
            this.configuration = configuration;
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            SSHAuthConfiguration.WithPassword auth;
            SSHAuthConfiguration sSHAuthConfiguration = this.configuration.auth();
            if (sSHAuthConfiguration instanceof SSHAuthConfiguration.WithPassword && ((auth = (SSHAuthConfiguration.WithPassword)sSHAuthConfiguration).savePassword() || CommonUtils.isNotEmpty((String)auth.password()))) {
                this.setPassword(auth.password());
            }
            return super.promptKeyboardInteractive(destination, name, instruction, prompt, echo);
        }

        public boolean promptPassword(String message) {
            SSHAuthConfiguration sSHAuthConfiguration = this.configuration.auth();
            if (sSHAuthConfiguration instanceof SSHAuthConfiguration.WithPassword) {
                SSHAuthConfiguration.WithPassword auth = (SSHAuthConfiguration.WithPassword)sSHAuthConfiguration;
                this.setPassword(auth.password());
            }
            return true;
        }

        public boolean promptPassphrase(String message) {
            SSHAuthConfiguration sSHAuthConfiguration = this.configuration.auth();
            if (sSHAuthConfiguration instanceof SSHAuthConfiguration.WithPassword) {
                SSHAuthConfiguration.WithPassword auth = (SSHAuthConfiguration.WithPassword)sSHAuthConfiguration;
                this.setPassphrase(auth.password());
            }
            return true;
        }

        public void showMessage(String message) {
            log.debug((Object)"SSH server message:");
            log.debug((Object)message);
        }

        public boolean promptYesNo(String question) {
            return DBWorkbench.getPlatformUI().confirmAction(SSHUIMessages.jsch_remote_host_identifier_changed_warning_title, question, true);
        }
    }
}

