/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.IHashEq;
import clojure.lang.IMapEntry;
import clojure.lang.IMapIterable;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.ISeq;
import clojure.lang.Murmur3;
import clojure.lang.RT;
import clojure.lang.Util;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public abstract class APersistentSet
extends AFn
implements IPersistentSet,
Collection,
Set,
Serializable,
IHashEq {
    private static final long serialVersionUID = 889908853183699706L;
    int _hash;
    int _hasheq;
    final IPersistentMap impl;

    protected APersistentSet(IPersistentMap impl2) {
        this.impl = impl2;
    }

    public String toString() {
        return RT.printString(this);
    }

    @Override
    public boolean contains(Object key2) {
        return this.impl.containsKey(key2);
    }

    @Override
    public Object get(Object key2) {
        return this.impl.valAt(key2);
    }

    @Override
    public int count() {
        return this.impl.count();
    }

    @Override
    public ISeq seq() {
        return RT.keys(this.impl);
    }

    @Override
    public Object invoke(Object arg1) {
        return this.get(arg1);
    }

    @Override
    public boolean equals(Object obj) {
        return APersistentSet.setEquals(this, obj);
    }

    public static boolean setEquals(IPersistentSet s1, Object obj) {
        if (s1 == obj) {
            return true;
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        Set m = (Set)obj;
        if (m.size() != s1.count()) {
            return false;
        }
        for (Object aM : m) {
            if (s1.contains(aM)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equiv(Object obj) {
        if (!(obj instanceof Set)) {
            return false;
        }
        Set m = (Set)obj;
        if (m.size() != this.size()) {
            return false;
        }
        for (Object aM : m) {
            if (this.contains(aM)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash2 = this._hash;
        if (hash2 == 0) {
            for (ISeq s = this.seq(); s != null; s = s.next()) {
                Object e2 = s.first();
                hash2 += Util.hash(e2);
            }
            this._hash = hash2;
        }
        return hash2;
    }

    @Override
    public int hasheq() {
        int cached = this._hasheq;
        if (cached == 0) {
            this._hasheq = cached = Murmur3.hashUnordered(this);
        }
        return cached;
    }

    @Override
    public Object[] toArray() {
        return RT.seqToArray(this.seq());
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] toArray(Object[] a) {
        return RT.seqToPassedArray(this.seq(), a);
    }

    @Override
    public int size() {
        return this.count();
    }

    @Override
    public boolean isEmpty() {
        return this.count() == 0;
    }

    @Override
    public Iterator iterator() {
        if (this.impl instanceof IMapIterable) {
            return ((IMapIterable)((Object)this.impl)).keyIterator();
        }
        return new Iterator(){
            private final Iterator iter;
            {
                this.iter = APersistentSet.this.impl.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                return ((IMapEntry)this.iter.next()).key();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

