﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/greengrass/GreengrassRequest.h>
#include <aws/greengrass/Greengrass_EXPORTS.h>
#include <aws/greengrass/model/Subscription.h>

#include <utility>

namespace Aws {
namespace Greengrass {
namespace Model {

/**
 */
class CreateSubscriptionDefinitionVersionRequest : public GreengrassRequest {
 public:
  AWS_GREENGRASS_API CreateSubscriptionDefinitionVersionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "CreateSubscriptionDefinitionVersion"; }

  AWS_GREENGRASS_API Aws::String SerializePayload() const override;

  AWS_GREENGRASS_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * A client token used to correlate requests and responses.
   */
  inline const Aws::String& GetAmznClientToken() const { return m_amznClientToken; }
  inline bool AmznClientTokenHasBeenSet() const { return m_amznClientTokenHasBeenSet; }
  template <typename AmznClientTokenT = Aws::String>
  void SetAmznClientToken(AmznClientTokenT&& value) {
    m_amznClientTokenHasBeenSet = true;
    m_amznClientToken = std::forward<AmznClientTokenT>(value);
  }
  template <typename AmznClientTokenT = Aws::String>
  CreateSubscriptionDefinitionVersionRequest& WithAmznClientToken(AmznClientTokenT&& value) {
    SetAmznClientToken(std::forward<AmznClientTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The ID of the subscription definition.
   */
  inline const Aws::String& GetSubscriptionDefinitionId() const { return m_subscriptionDefinitionId; }
  inline bool SubscriptionDefinitionIdHasBeenSet() const { return m_subscriptionDefinitionIdHasBeenSet; }
  template <typename SubscriptionDefinitionIdT = Aws::String>
  void SetSubscriptionDefinitionId(SubscriptionDefinitionIdT&& value) {
    m_subscriptionDefinitionIdHasBeenSet = true;
    m_subscriptionDefinitionId = std::forward<SubscriptionDefinitionIdT>(value);
  }
  template <typename SubscriptionDefinitionIdT = Aws::String>
  CreateSubscriptionDefinitionVersionRequest& WithSubscriptionDefinitionId(SubscriptionDefinitionIdT&& value) {
    SetSubscriptionDefinitionId(std::forward<SubscriptionDefinitionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * A list of subscriptions.
   */
  inline const Aws::Vector<Subscription>& GetSubscriptions() const { return m_subscriptions; }
  inline bool SubscriptionsHasBeenSet() const { return m_subscriptionsHasBeenSet; }
  template <typename SubscriptionsT = Aws::Vector<Subscription>>
  void SetSubscriptions(SubscriptionsT&& value) {
    m_subscriptionsHasBeenSet = true;
    m_subscriptions = std::forward<SubscriptionsT>(value);
  }
  template <typename SubscriptionsT = Aws::Vector<Subscription>>
  CreateSubscriptionDefinitionVersionRequest& WithSubscriptions(SubscriptionsT&& value) {
    SetSubscriptions(std::forward<SubscriptionsT>(value));
    return *this;
  }
  template <typename SubscriptionsT = Subscription>
  CreateSubscriptionDefinitionVersionRequest& AddSubscriptions(SubscriptionsT&& value) {
    m_subscriptionsHasBeenSet = true;
    m_subscriptions.emplace_back(std::forward<SubscriptionsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_amznClientToken;

  Aws::String m_subscriptionDefinitionId;

  Aws::Vector<Subscription> m_subscriptions;
  bool m_amznClientTokenHasBeenSet = false;
  bool m_subscriptionDefinitionIdHasBeenSet = false;
  bool m_subscriptionsHasBeenSet = false;
};

}  // namespace Model
}  // namespace Greengrass
}  // namespace Aws
