/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResolveClassUtil {
    @Nullable
    public static PsiClass resolveClass(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiFile containingFile) {
        if (ref == null) {
            ResolveClassUtil.$$$reportNull$$$0(0);
        }
        if (containingFile == null) {
            ResolveClassUtil.$$$reportNull$$$0(1);
        }
        if (ref instanceof PsiJavaCodeReferenceElementImpl && ((PsiJavaCodeReferenceElementImpl)ref).getKindEnum(containingFile) == PsiJavaCodeReferenceElementImpl.Kind.CLASS_IN_QUALIFIED_NEW_KIND) {
            PsiClass qualifierClass;
            PsiType qualifierType;
            PsiExpression qualifier;
            PsiNewExpression parent2 = (PsiNewExpression)PsiTreeUtil.getContextOfType((PsiElement)ref, PsiNewExpression.class);
            if (parent2 != null && (qualifier = parent2.getQualifier()) != null && (qualifierType = qualifier.getType()) instanceof PsiClassType && (qualifierClass = PsiUtil.resolveClassInType(qualifierType)) != null) {
                return qualifierClass.findInnerClassByName(ref.getText(), true);
            }
        } else {
            PsiElement classNameElement = ref.getReferenceNameElement();
            if (classNameElement instanceof PsiIdentifier) {
                String className = classNameElement.getText();
                ClassResolverProcessor processor = new ClassResolverProcessor(className, ref, containingFile);
                PsiScopesUtil.resolveAndWalk(processor, ref, null);
                if (processor.getResult().length == 1) {
                    return (PsiClass)processor.getResult()[0].getElement();
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "ref";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "containingFile";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/source/resolve/ResolveClassUtil";
        objectArray[2] = "resolveClass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

