# Copyright (C) 2024 Intel Corporation
# SPDX-License-Identifier: MIT

import os
import sys

sys.path.append(os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__)))))
from tools.common.common_args import CommonArgParser
from tools.common.virtual_environment import VirtualEnvironment
from tools.installer.installers import InstallerFactory


class InstallerArgParser(CommonArgParser):
    def __init__(self):
        super().__init__(description='Install the metric post processor (MPP).\n'
            'Use \'Virtual Environment Options\' to create a fresh virtual environment.\n'
            'To update an existing virtual environment, activate the virtual environment and '
            'run install.py in the active virtual environment without \'Virtual Environment Options\'.',
                         add_help=(__name__ == '__main__'))
        self.add_installer_args()
        self.add_venv_args()
        self.add_logging_args()

    def parse_args(self, args=None, namespace=None):
        return super().parse_args(args, namespace)

    def add_installer_args(self):
        install_options = self.add_argument_group('Install options')
        install_options.add_argument('--percentile',
                            action='store_true',
                            default=False,
                            help='Install packages required to support percentile calculation.')


def main():
    parser = InstallerArgParser()
    args = parser.parse_args()

    installer = InstallerFactory.create_installer(args.percentile, args.verbose)
    if args.venv_args:
        venv = VirtualEnvironment(args.venv_args, installer)
        venv.setup()
    else:
        installer.install()


if __name__ == '__main__':
    main()


