#
# Copyright (C) 2021 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#


# ------------------------------------------------------------------------------
# This example shows how to obtain data from the topdown tree representation of
# the data set with information about MPI phases.
# ------------------------------------------------------------------------------

import sys

try:

    import advisor

except ImportError:

    print(
        """Import error: Python could not resolve path to Advisor's pythonapi directory.
        To fix, either manually add path to the pythonapi directory into PYTHONPATH environment
        variable, or use advixe-vars.* scripts to set up product environment variables automatically."""
    )
    sys.exit(1)

# Check command-line arguments.
if len(sys.argv) < 2:
    print('Usage: "python {} path_to_project_dir"'.format(__file__))
    sys.exit(2)

# Open the Advisor Project and load the data.
project = advisor.open_project(sys.argv[1])
data = project.load(advisor.SURVEY)

# Check that data on MPI phases is collected
if not data.mpi_phases_collected:
    print("Data on MPI phases is not collected.")
else:
    # Traverse the topdown tree with the MPI phase instances, each entry has a parent and children.
    for row in data.topdown:
        stack = [(row, 0)]
        while stack:
            v, level = stack.pop()
            for c in v.get_children():
                stack.append((c, level + 1))
            print("-" * level + v["function_call_sites_and_loops"])
            print(" " * (level + 7) + "ID: {}, Callsite: {}, T Time: {}, S Time: {}, MPI Phase ID: {}, Compute Phase ID: {}, MPI Phase Inst: {}".format(\
                v["key_column"],
                v["callsite"],
                v["total_time"],
                v["self_time"],
                v["mpi_phase_id"],
                v["compute_phase_id"],
                v["mpi_phase_instance"]
            ))
