##
## Copyright 2016 Intel Corporation.
##
##
## This software and the related documents are Intel copyrighted materials, and your use of them is governed by
## the express license under which they were provided to you ('License'). Unless the License provides otherwise,
## you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
## documents without Intel's prior written permission.
## This software and the related documents are provided as is, with no express or implied warranties, other than
## those that are expressly stated in the License.
##

#
# Base commands
#
ARFLAGS ?= rvcs

#
# System configuration detection
#

SYSTEM_SFX := $(shell uname)
G_SYSTEM := Linux

ifndef $(ARCH)
	ARCH_SFX := $(shell uname -m)
	ifeq ($(ARCH_SFX),x86_64)
		ARCH := intel64
	endif
endif

ifeq ($(ARCH),intel64)
	G_ARCH := intel64
endif
ifeq ($(G_ARCH),)
$(error ARCH is invalid)
endif

# Detect whether the compiler is Intel(R) oneAPI DPC++/C++ Compiler
ifeq ($(CC),icx)
	IS_ICX := 1
else ifeq ($(CXX),icpx)
	IS_ICX := 1
else
	IS_ICX := 0
endif

#
# Base build configuration
#
ifndef $(CONF)
	ifneq ($(TBBROOT),)
		CONF := release_tbb
	else
		CONF := release_omp
	endif
endif

ifeq ($(CONF),debug_omp)
	G_CONF      := debug
	G_USETBB    := 0
	G_USEOMP    := 1
endif
ifeq ($(CONF),debug_tbb)
	G_CONF      := debug
	G_USETBB    := 1
	G_USEOMP    := 0
endif
ifeq ($(CONF),release_omp)
	G_CONF      := release
	G_USETBB    := 0
	G_USEOMP    := 1
endif
ifeq ($(CONF),release_tbb)
	G_CONF      := release
	G_USETBB    := 1
	G_USEOMP    := 0
endif
ifeq ($(G_CONF),)
$(error CONF is invalid)
endif

ifeq ($(G_CONF),debug)
	G_CFLAGS   += -g -D_DEBUG
	G_CXXFLAGS += -g -D_DEBUG
endif
G_CFLAGS   += -Wformat -Wformat-security -std=c99 -pedantic
G_CXXFLAGS += -Wformat -Wformat-security

# Alias for OpenMP flag:
# * "-qopenmp" is used in icx/icpx
# * "-fopenmp" is used in gcc/g++ and clang/clang++
ifeq ($(CC),icx)
	G_C_OPENMP := -qopenmp
else
	G_C_OPENMP := -fopenmp
endif
ifeq ($(CXX),icpx)
	G_CXX_OPENMP := -qopenmp
else
	G_CXX_OPENMP := -fopenmp
endif

# Old/new (v2) directory layout machinery.
# If IPP_PRESERVE_OLD_LAYOUT is defined, the old directory layout is used.
# By default the new (v2) directory layout is used.
ifeq ($(IPP_PRESERVE_OLD_LAYOUT),)
	G_INCLUDE_RELATIVE_PATH := include/ipp
	G_LIB_RELATIVE_PATH64   := lib
else
	G_INCLUDE_RELATIVE_PATH := include
	G_LIB_RELATIVE_PATH64   := lib/intel64
	G_CFLAGS   += -DIPP_PRESERVE_OLD_LAYOUT
	G_CXXFLAGS += -DIPP_PRESERVE_OLD_LAYOUT
endif

ifeq ($(ARCH),intel64)
	G_IPP_PATH_SUFFIX ?= $(G_LIB_RELATIVE_PATH64)
	G_TBB_PATH_SUFFIX ?= $(G_LIB_RELATIVE_PATH64)/gcc4.8
endif

#
# Paths configuration
#
G_MAKE_ROOT      := $(shell pwd)/
G_BUILD_ROOT     := $(G_MAKE_ROOT)/_build/
$(shell mkdir -p $(G_BUILD_ROOT))

ifeq ($(G_USETBB),1)
	G_CONF_DIR := $(G_CONF)_tbb
else
	ifeq ($(G_USEOMP),1)
		G_CONF_DIR := $(G_CONF)_omp
	else
		$(error CONF is invalid)
	endif
endif

# Requred compilation flags:
# G_LIB_CFLAGS   - Library C flags
# G_LIB_LDFLAGS  - Library linker flags
# G_EXE_CFLAGS   - Executable C flags
# G_EXE_LDFLAGS  - Executable linker flags
G_LIB_CFLAGS   := -O3 -fPIC -D_FORTIFY_SOURCE=2
G_LIB_LDFLAGS  := -z noexecstack

# `-ffreestanding` flag should not be used when TL is based on Intel(R) oneAPI Threading Building Blocks (oneTBB)
# because Intel (R) oneTBB doesn't support freestanding environment
ifeq ($(G_USETBB),1)
# `-no-intel-lib=libirc` flag prevents the appearance of unnecessary external symbols like `_intel_fast_memset` in static libraries
# while using icx without `-ffreestanding` flag
	ifndef DYNAMIC
		ifeq ($(IS_ICX),1)
			G_LIB_CFLAGS += -no-intel-lib=libirc
		endif
	endif
else
	G_LIB_CFLAGS += -ffreestanding
endif

G_EXE_CFLAGS   += -O3 -fPIC -D_FORTIFY_SOURCE=2
G_EXE_LDFLAGS  := -pie -z noexecstack -z relro -z now

G_EXE_LDFLAGS += -lpthread

ifeq ($(G_FSPS_SUPPORTED),1)
	G_LIB_CFLAGS += -fstack-protector-strong
	G_EXE_CFLAGS += -fstack-protector-strong
else
	G_LIB_CFLAGS += -fstack-protector
	G_EXE_CFLAGS += -fstack-protector
endif

ifneq ($(G_USECET),0)
	G_LIB_CFLAGS += -fcf-protection
	G_EXE_CFLAGS += -fcf-protection
endif

G_LIB_CFLAGS += -D_XOPEN_SOURCE=500
G_LIB_LDFLAGS += -Wl,-z,relro -Wl,-z,now -nostdlib
G_EXE_CFLAGS += -D_XOPEN_SOURCE=500

ifeq ($(G_USETBB),1)
	G_LIB_CFLAGS  += -std=c++11 -DUSE_TBB -I$(TBBROOT)/include
	G_LIB_LDFLAGS += -L$(TBBROOT)/$(G_TBB_PATH_SUFFIX) -ltbb
	G_EXE_LDFLAGS += -L$(TBBROOT)/$(G_TBB_PATH_SUFFIX) -ltbb
	G_EXAMPLE_CFLAGS := $(G_EXE_CFLAGS) -std=c++11 -DUSE_TBB -I$(TBBROOT)/include
	G_LIB_SFX := _tbb
endif

ifeq ($(G_USEOMP), 1)
	G_LIB_CFLAGS += -DUSE_OMP $(G_C_OPENMP)
	G_CFLAGS     += $(G_C_OPENMP)
	G_LIB_SFX    := _omp
	G_CXXFLAGS   += $(G_CXX_OPENMP)
	G_EXAMPLE_CFLAGS := $(G_EXE_CFLAGS) -DUSE_OMP $(G_C_OPENMP)
endif

# Get IPP Interface version

G_IPP_INTERFACE_VERSION_MAJOR := $(shell sed -n 's/\#define IPP_INTERFACE_VERSION_MAJOR *\([0-9*]\)/\1/p' ${IPPROOT}/$(G_INCLUDE_RELATIVE_PATH)/ippversion.h)
G_IPP_INTERFACE_VERSION_MINOR := $(shell sed -n 's/\#define IPP_INTERFACE_VERSION_MINOR *\([0-9*]\)/\1/p' ${IPPROOT}/$(G_INCLUDE_RELATIVE_PATH)/ippversion.h)

#
# Export global vars
#
export G_SYSTEM
export G_MAKE_ROOT
export G_BUILD_ROOT
export G_ARCH
export G_CONF
export G_CONF_DIR
export G_USETBB
export G_USEOMP
export G_CFLAGS
export G_CXXFLAGS
export G_C_OPENMP
export G_CXX_OPENMP
export G_INCLUDE_RELATIVE_PATH
export G_IPP_PATH_SUFFIX
export G_TBB_PATH_SUFFIX

export G_LIB_CFLAGS
export G_LIB_LDFLAGS
export G_EXE_CFLAGS
export G_EXE_LDFLAGS
export G_EXAMPLE_CFLAGS

export ARFLAGS

export G_IPP_INTERFACE_VERSION_MAJOR
export G_IPP_INTERFACE_VERSION_MINOR
export G_LIB_SFX
