\name{ImageRegistrationMethod}
\alias{ImageRegistrationMethod}
\title{ImageRegistrationMethod}
\Rdversion{1.1}
\docType{class}
\description{
An interface method to the modular ITKv4 registration framework.
ImageRegistrationMethod}
\details{
This interface method class encapsulates typical registration usage by
incorporating all the necessary elements for performing a simple image
registration between two images. This method also allows for
multistage registration whereby each stage is characterized by
possibly different transforms and different image metrics. For
example, many users will want to perform a linear registration
followed by deformable registration where both stages are performed in
multiple levels. Each level can be characterized by:
the resolution of the virtual domain image (see below)
smoothing of the fixed and moving images
 Multiple stages are handled by linking multiple instantiations of
this class where the output transform is added to the optional
composite transform input.
See:
itk::ImageRegistrationMethodv4
itk::ImageToImageMetricv4
itk::ObjectToObjectOptimizerBaseTemplate
ImageRegistrationMethod}
%C++ includes: sitkImageRegistrationMethod.h
\section{Methods}{
\describe{
\item{Transform Execute(const Image &fixed, const Image &moving):}{
Optimize the configured registration problem.
}
\item{unsigned int GetCurrentLevel() const:}{}
\item{uint64_t GetMetricNumberOfValidPoints() const:}{
Current number of points used of metric evaluation
This is a active measurement connected to the registration processes
during registration. This number is number of point in the virtual
domain which overlap the fixed image and the moving image. It is valid
for sparse or dense sampling. After execution of registration this
will contain the last value.
}
\item{const std::vector< double > & GetMetricSamplingPercentagePerLevel() const:}{
Get the percentage of pixels used for metric evaluation.
}
\item{double GetMetricValue() const:}{}
\item{std::string GetName() const override:}{
return user readable name for the filter
}
\item{double GetOptimizerConvergenceValue() const:}{}
\item{unsigned int GetOptimizerIteration() const:}{
Active measurements which can be obtained during call backs.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetOptimizerLearningRate() const:}{}
\item{std::vector< double > GetOptimizerPosition() const:}{}
\item{std::vector< double > GetOptimizerScales() const:}{
Get the OptimizerScales.
If the scales are explicitly set then this method returns those
values. If an estimator is used then this is an active measurement
returning the scales estimated by the estimator and is only available
during execution.
}
\item{std::string GetOptimizerStopConditionDescription() const:}{
Measurement updated at the end of execution.
}
\item{ ImageRegistrationMethod():}{}
\item{double MetricEvaluate(const Image &fixed, const Image &moving):}{
Get the value of the metric given the state of the method.
Passing a fixed and moving image, this method constructs and
configures a metric object to obtain the value. This will take into
consideration the current transforms, metric, interpolator, and image
masks. It does not take into consideration the sampling strategy,
smoothing sigmas, or the shrink factors.
}
\item{void SetInitialTransformAsBSpline(BSplineTransform &transform, bool inPlace=true, const std::vector< unsigned int > &scaleFactors=std::vector< unsigned int >()):}{
Set an initial BSpline transform to optimize.
A specialization of SetInitialTransform for BSplineTransforms which
can take an additional scaleFactors parameter. The scaleFactors
specifies the a isotropic scaling factor per level for the BSpline
transform mesh size with respect to the initial transform. For example
to double the BSpline mesh resolution at each of 3 levels the vector
[1,2,4] should be provided.
If a per level scale factor is 0 or omitted than no transform adapter
will be created for that level.
See:
itk::BSplineTransformParametersAdaptor
}
\item{Self SetMetricAsANTSNeighborhoodCorrelation(unsigned int radius):}{
Use normalized cross correlation using a small neighborhood for each
voxel between two images, with speed optimizations for dense
registration.
See:
itk::ANTSNeighborhoodCorrelationImageToImageMetricv4
}
\item{Self SetMetricAsCorrelation():}{
Use negative normalized cross correlation image metric.
See:
itk::CorrelationImageToImageMetricv4
}
\item{Self SetMetricAsDemons(double intensityDifferenceThreshold=0.001):}{
Use demons image metric.
See:
itk::DemonsImageToImageMetricv4
}
\item{Self SetMetricAsJointHistogramMutualInformation(unsigned int numberOfHistogramBins=20, double varianceForJointPDFSmoothing=1.5):}{
Use mutual information between two images.
See:
itk::JointHistogramMutualInformationImageToImageMetricv4
}
\item{Self SetMetricAsMattesMutualInformation(unsigned int numberOfHistogramBins=50):}{
Use the mutual information between two images to be registered using
the method of Mattes et al.
See:
itk::MattesMutualInformationImageToImageMetricv4
}
\item{Self SetMetricAsMeanSquares():}{
Use negative means squares image metric.
See:
itk::MeanSquaresImageToImageMetricv4
}
\item{Self SetMetricFixedMask(const Image &binaryMask):}{
Set an image mask in order to restrict the sampled points for the
metric.
The image is expected to be in the same physical space as the
FixedImage, and if the pixel type is not UInt8 than the image will
base cast.
See:
itk::ImageToImageMetricv4::SetFixedImageMask
}
\item{Self SetMetricMovingMask(const Image &binaryMask):}{
Set an image mask in order to restrict the sampled points for the
metric in the moving image space.
The image is expected to be in the same physical space as the
MovingImage, and if the pixel type is not UInt8 than the image will
base cast.
See:
itk::ImageToImageMetricv4::SetMovingImageMask
}
\item{Self SetMetricSamplingStrategy(MetricSamplingStrategyType strategy):}{
Set sampling strategy for sample generation.
See:
itk::ImageRegistrationMethodv4::SetMetricSamplingStrategy
}
\item{Self SetOptimizerAsAmoeba(double simplexDelta, unsigned int numberOfIterations, double parametersConvergenceTolerance=1e-8, double functionConvergenceTolerance=1e-4, bool withRestarts=false):}{
Set optimizer to Nelder-Mead downhill simplex algorithm.
See:
itk::AmoebaOptimizerv4
}
\item{Self SetOptimizerAsConjugateGradientLineSearch(double learningRate, unsigned int numberOfIterations, double convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10, double lineSearchLowerLimit=0, double lineSearchUpperLimit=5.0, double lineSearchEpsilon=0.01, unsigned int lineSearchMaximumIterations=20, EstimateLearningRateType estimateLearningRate=Once, double maximumStepSizeInPhysicalUnits=0.0):}{
Conjugate gradient descent optimizer with a golden section line search
for nonlinear optimization.
See:
itk::ConjugateGradientLineSearchOptimizerv4Template
}
\item{Self SetOptimizerAsExhaustive(const std::vector< unsigned int > &numberOfSteps, double stepLength=1.0):}{
Set the optimizer to sample the metric at regular steps.
At each iteration the GetOptimizerIteration, can be used to index into
the sampling grid along with the GetCurrentMetricValue.
The resulting transform and value at the end of execution is the best
location.
The OptimizerScales can be used to perform anisotropic sampling.
This optimizer is not suitable for use in conjunction with the
multiple scales.
See:
itk::ExhaustiveOptimizerv4
}
\item{Self SetOptimizerAsGradientDescent(double learningRate, unsigned int numberOfIterations, double convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10, EstimateLearningRateType estimateLearningRate=Once, double maximumStepSizeInPhysicalUnits=0.0):}{
Gradient descent optimizer.
See:
itk::GradientDescentOptimizerv4Template
}
\item{Self SetOptimizerAsGradientDescentLineSearch(double learningRate, unsigned int numberOfIterations, double convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10, double lineSearchLowerLimit=0, double lineSearchUpperLimit=5.0, double lineSearchEpsilon=0.01, unsigned int lineSearchMaximumIterations=20, EstimateLearningRateType estimateLearningRate=Once, double maximumStepSizeInPhysicalUnits=0.0):}{
Gradient descent optimizer with a golden section line search.
See:
itk::GradientDescentLineSearchOptimizerv4Template
}
\item{Self SetOptimizerAsLBFGS2(double solutionAccuracy=1e-5, unsigned int numberOfIterations=0, unsigned int hessianApproximateAccuracy=6, unsigned int deltaConvergenceDistance=0, double deltaConvergenceTolerance=1e-5, unsigned int lineSearchMaximumEvaluations=40, double lineSearchMinimumStep=1e-20, double lineSearchMaximumStep=1e20, double lineSearchAccuracy=1e-4):}{
Limited memory Broyden Fletcher Goldfarb Shannon minimization without
bounds.
The default parameters utilize LBFGSB in unbounded mode. This version
is from LibLBFGS.
There are upto 3 stopping criteria:
the solution accuracy which is the magnitude of the gradient
the delta convergence which ensures the decrease of the metric
maximum number of iterations
See:
itk::LBFGS2Optimizerv4
}
\item{Self SetOptimizerAsLBFGSB(double gradientConvergenceTolerance=1e-5, unsigned int numberOfIterations=500, unsigned int maximumNumberOfCorrections=5, unsigned int maximumNumberOfFunctionEvaluations=2000, double costFunctionConvergenceFactor=1e+7, double lowerBound=std::numeric_limits< double >::min(), double upperBound=std::numeric_limits< double >::max(), bool trace=false):}{
Limited memory Broyden Fletcher Goldfarb Shannon minimization with
simple bounds.
The default parameters utilize LBFGSB in unbounded mode.
See:
itk::LBFGSBOptimizerv4
}
\item{Self SetOptimizerAsOnePlusOneEvolutionary(unsigned int numberOfIterations=100, double epsilon=1.5e-4, double initialRadius=1.01, double growthFactor=-1.0, double shrinkFactor=-1.0, unsigned int seed=sitkWallClock):}{
1+1 evolutionary optimizer strategy.
The seed parameter is used to seed the pseudo-random number generator.
If the seed parameter is 0, then the wall clock is used to seed,
otherwise the fixed seed is used for reproducible behavior.
See:
itk::OnePlusOneEvolutionaryOptimizerv4
}
\item{Self SetOptimizerAsPowell(unsigned int numberOfIterations=100, unsigned int maximumLineIterations=100, double stepLength=1, double stepTolerance=1e-6, double valueTolerance=1e-6):}{
Powell optimization using Brent line search.
See:
itk::PowellOptimizerv4
}
\item{Self SetOptimizerAsRegularStepGradientDescent(double learningRate, double minStep, unsigned int numberOfIterations, double relaxationFactor=0.5, double gradientMagnitudeTolerance=1e-4, EstimateLearningRateType estimateLearningRate=Never, double maximumStepSizeInPhysicalUnits=0.0):}{
Regular Step Gradient descent optimizer.
See:
itk::RegularStepGradientDescentOptimizerv4
}
\item{Self SetOptimizerScales(const std::vector< double > &scales):}{
Manually set per parameter weighting for the transform parameters.
}
\item{Self SetOptimizerScalesFromIndexShift(unsigned int centralRegionRadius=5, double smallParameterVariation=0.01):}{
Estimate scales from maximum voxel shift in index space cause by
parameter change.
See:
itk::RegistrationParameterScalesFromIndexShift
}
\item{Self SetOptimizerScalesFromJacobian(unsigned int centralRegionRadius=5):}{
Estimate scales from Jacobian norms.
This scales estimator works well with versor based transforms.
See:
itk::RegistrationParameterScalesFromJacobian
}
\item{Self SetOptimizerScalesFromPhysicalShift(unsigned int centralRegionRadius=5, double smallParameterVariation=0.01):}{
Estimating scales of transform parameters a step sizes, from the
maximum voxel shift in physical space caused by a parameter change.
See:
itk::RegistrationParameterScalesFromPhysicalShift
}
\item{Self SetShrinkFactorsPerLevel(const std::vector< unsigned int > &shrinkFactors):}{
Set the isotropic shrink factors for each level.
The virtual domain image is shrunk by this factor relative to the full
size of the original virtual domain.
See:
itk::ImageRegistrationMethodv4::SetShrinkFactorsPerLevel
}
\item{Self SetSmoothingSigmasPerLevel(const std::vector< double > &smoothingSigmas):}{
Set the sigmas of Gaussian used for smoothing.
The smoothing is applied to both the fixed and the moving images at
each level. The number of smoothing sigmas must match the number of
shrink factors.
See:
itk::ImageRegistrationMethodv4::SetSmoothingSigmasPerLevel
}
\item{bool StopRegistration():}{
Stop Registration if actively running.
This is an active method which can be called during a callback.
Invoking this method will halt the registration at the current
iteration, if supported by the optimizer. The LBFGSB, LBFGS2, and the
Amoeba optimizers do not support user stopping.
If user stopping is not supported or the optimizer is available ( not
executed ), then false will be returned.
}
\item{std::string ToString() const override:}{
Print the information about the object to a string.
If called when the process is being executed ( during a callback ),
the ITK Optimizer and Transform objects will be printed.
}
\item{ ~ImageRegistrationMethod() override:}{}
}
}
