# This file has been autogenerated by the pywayland scanner

# Copyright © 2022 Andri Yngvason
# Copyright © 2024 Simon Ser
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import Global, Interface, Proxy, Resource


class ExtImageCaptureSourceV1(Interface):
    """Opaque image capture source object

    The image capture source object is an opaque descriptor for a capturable
    resource.  This resource may be any sort of entity from which an image may
    be derived.

    Note, because :class:`ExtImageCaptureSourceV1` objects are created from
    multiple independent factory interfaces, the
    :class:`ExtImageCaptureSourceV1` interface is frozen at version 1.
    """

    name = "ext_image_capture_source_v1"
    version = 1


class ExtImageCaptureSourceV1Proxy(Proxy[ExtImageCaptureSourceV1]):
    interface = ExtImageCaptureSourceV1

    @ExtImageCaptureSourceV1.request()
    def destroy(self) -> None:
        """Delete this object

        Destroys the image capture source. This request may be sent at any time
        by the client.
        """
        self._marshal(0)
        self._destroy()


class ExtImageCaptureSourceV1Resource(Resource):
    interface = ExtImageCaptureSourceV1


class ExtImageCaptureSourceV1Global(Global):
    interface = ExtImageCaptureSourceV1


ExtImageCaptureSourceV1._gen_c()
ExtImageCaptureSourceV1.proxy_class = ExtImageCaptureSourceV1Proxy
ExtImageCaptureSourceV1.resource_class = ExtImageCaptureSourceV1Resource
ExtImageCaptureSourceV1.global_class = ExtImageCaptureSourceV1Global
