# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "databoxedge device storage-account-credential update",
)
class Update(AAZCommand):
    """Update the storage account credential.

    :example: Update storage account credential
        az databoxedge device storage-account-credential update --device-name name -n sac-name -g rg --account-type GeneralPurposeStorage --alias testsac --ssl-status Enabled --account-key "{encryptionAlgorithm:AES256,value:xxx,encryptionCertThumbprint:xxx}"
    """

    _aaz_info = {
        "version": "2023-07-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.databoxedge/databoxedgedevices/{}/storageaccountcredentials/{}", "2023-07-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    AZ_SUPPORT_GENERIC_UPDATE = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.device_name = AAZStrArg(
            options=["--device-name"],
            help="The device name.",
            required=True,
            id_part="name",
        )
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="The storage account credential name.",
            required=True,
            id_part="child_name_1",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.account_key = AAZObjectArg(
            options=["--account-key"],
            arg_group="Properties",
            help="Encrypted storage key.",
            nullable=True,
        )
        _args_schema.account_type = AAZStrArg(
            options=["--account-type"],
            arg_group="Properties",
            help="Type of storage accessed on the storage account.",
            enum={"BlobStorage": "BlobStorage", "GeneralPurposeStorage": "GeneralPurposeStorage"},
        )
        _args_schema.alias = AAZStrArg(
            options=["--alias"],
            arg_group="Properties",
            help="Alias for the storage account.",
        )
        _args_schema.blob_domain_name = AAZStrArg(
            options=["--blob-domain-name"],
            arg_group="Properties",
            help="Blob end point for private clouds.",
            nullable=True,
        )
        _args_schema.connection_string = AAZStrArg(
            options=["--connection-string"],
            arg_group="Properties",
            help="Connection string for the storage account. Use this string if username and account key are not specified.",
            nullable=True,
        )
        _args_schema.ssl_status = AAZStrArg(
            options=["--ssl-status"],
            arg_group="Properties",
            help="Signifies whether SSL needs to be enabled or not.",
            enum={"Disabled": "Disabled", "Enabled": "Enabled"},
        )
        _args_schema.storage_account_id = AAZStrArg(
            options=["--storage-account-id"],
            arg_group="Properties",
            help="Id of the storage account.",
            nullable=True,
        )
        _args_schema.user_name = AAZStrArg(
            options=["--user-name"],
            arg_group="Properties",
            help="Username for the storage account.",
            nullable=True,
        )

        account_key = cls._args_schema.account_key
        account_key.encryption_algorithm = AAZStrArg(
            options=["encryption-algorithm"],
            help="The algorithm used to encrypt \"Value\".",
            enum={"AES256": "AES256", "None": "None", "RSAES_PKCS1_v_1_5": "RSAES_PKCS1_v_1_5"},
        )
        account_key.encryption_cert_thumbprint = AAZStrArg(
            options=["encryption-cert-thumbprint"],
            help="Thumbprint certificate used to encrypt \"Value\". If the value is unencrypted, it will be null.",
            nullable=True,
        )
        account_key.value = AAZStrArg(
            options=["value"],
            help="The value of the secret.",
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.StorageAccountCredentialsGet(ctx=self.ctx)()
        self.pre_instance_update(self.ctx.vars.instance)
        self.InstanceUpdateByJson(ctx=self.ctx)()
        self.InstanceUpdateByGeneric(ctx=self.ctx)()
        self.post_instance_update(self.ctx.vars.instance)
        yield self.StorageAccountCredentialsCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    @register_callback
    def pre_instance_update(self, instance):
        pass

    @register_callback
    def post_instance_update(self, instance):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class StorageAccountCredentialsGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/storageAccountCredentials/{name}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "deviceName", self.ctx.args.device_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "name", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2023-07-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _UpdateHelper._build_schema_storage_account_credential_read(cls._schema_on_200)

            return cls._schema_on_200

    class StorageAccountCredentialsCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/storageAccountCredentials/{name}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "deviceName", self.ctx.args.device_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "name", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2023-07-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=self.ctx.vars.instance,
            )

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _UpdateHelper._build_schema_storage_account_credential_read(cls._schema_on_200)

            return cls._schema_on_200

    class InstanceUpdateByJson(AAZJsonInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance(self.ctx.vars.instance)

        def _update_instance(self, instance):
            _instance_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=instance,
                typ=AAZObjectType
            )
            _builder.set_prop("properties", AAZObjectType, ".", typ_kwargs={"flags": {"required": True, "client_flatten": True}})

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("accountKey", AAZObjectType, ".account_key")
                properties.set_prop("accountType", AAZStrType, ".account_type", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("alias", AAZStrType, ".alias", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("blobDomainName", AAZStrType, ".blob_domain_name")
                properties.set_prop("connectionString", AAZStrType, ".connection_string")
                properties.set_prop("sslStatus", AAZStrType, ".ssl_status", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("storageAccountId", AAZStrType, ".storage_account_id")
                properties.set_prop("userName", AAZStrType, ".user_name")

            account_key = _builder.get(".properties.accountKey")
            if account_key is not None:
                account_key.set_prop("encryptionAlgorithm", AAZStrType, ".encryption_algorithm", typ_kwargs={"flags": {"required": True}})
                account_key.set_prop("encryptionCertThumbprint", AAZStrType, ".encryption_cert_thumbprint", typ_kwargs={"flags": {"secret": True}})
                account_key.set_prop("value", AAZStrType, ".value", typ_kwargs={"flags": {"required": True}})

            return _instance_value

    class InstanceUpdateByGeneric(AAZGenericInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance_by_generic(
                self.ctx.vars.instance,
                self.ctx.generic_update_args
            )


class _UpdateHelper:
    """Helper class for Update"""

    _schema_storage_account_credential_read = None

    @classmethod
    def _build_schema_storage_account_credential_read(cls, _schema):
        if cls._schema_storage_account_credential_read is not None:
            _schema.id = cls._schema_storage_account_credential_read.id
            _schema.name = cls._schema_storage_account_credential_read.name
            _schema.properties = cls._schema_storage_account_credential_read.properties
            _schema.system_data = cls._schema_storage_account_credential_read.system_data
            _schema.type = cls._schema_storage_account_credential_read.type
            return

        cls._schema_storage_account_credential_read = _schema_storage_account_credential_read = AAZObjectType()

        storage_account_credential_read = _schema_storage_account_credential_read
        storage_account_credential_read.id = AAZStrType(
            flags={"read_only": True},
        )
        storage_account_credential_read.name = AAZStrType(
            flags={"read_only": True},
        )
        storage_account_credential_read.properties = AAZObjectType(
            flags={"required": True, "client_flatten": True},
        )
        storage_account_credential_read.system_data = AAZObjectType(
            serialized_name="systemData",
            flags={"read_only": True},
        )
        storage_account_credential_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_storage_account_credential_read.properties
        properties.account_key = AAZObjectType(
            serialized_name="accountKey",
        )
        properties.account_type = AAZStrType(
            serialized_name="accountType",
            flags={"required": True},
        )
        properties.alias = AAZStrType(
            flags={"required": True},
        )
        properties.blob_domain_name = AAZStrType(
            serialized_name="blobDomainName",
        )
        properties.connection_string = AAZStrType(
            serialized_name="connectionString",
        )
        properties.ssl_status = AAZStrType(
            serialized_name="sslStatus",
            flags={"required": True},
        )
        properties.storage_account_id = AAZStrType(
            serialized_name="storageAccountId",
        )
        properties.user_name = AAZStrType(
            serialized_name="userName",
        )

        account_key = _schema_storage_account_credential_read.properties.account_key
        account_key.encryption_algorithm = AAZStrType(
            serialized_name="encryptionAlgorithm",
            flags={"required": True},
        )
        account_key.encryption_cert_thumbprint = AAZStrType(
            serialized_name="encryptionCertThumbprint",
            flags={"secret": True},
        )
        account_key.value = AAZStrType(
            flags={"required": True},
        )

        system_data = _schema_storage_account_credential_read.system_data
        system_data.created_at = AAZStrType(
            serialized_name="createdAt",
        )
        system_data.created_by = AAZStrType(
            serialized_name="createdBy",
        )
        system_data.created_by_type = AAZStrType(
            serialized_name="createdByType",
        )
        system_data.last_modified_at = AAZStrType(
            serialized_name="lastModifiedAt",
        )
        system_data.last_modified_by = AAZStrType(
            serialized_name="lastModifiedBy",
        )
        system_data.last_modified_by_type = AAZStrType(
            serialized_name="lastModifiedByType",
        )

        _schema.id = cls._schema_storage_account_credential_read.id
        _schema.name = cls._schema_storage_account_credential_read.name
        _schema.properties = cls._schema_storage_account_credential_read.properties
        _schema.system_data = cls._schema_storage_account_credential_read.system_data
        _schema.type = cls._schema_storage_account_credential_read.type


__all__ = ["Update"]
